/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.standalone.commands;

import aroma1997.backup.common.info.ExistingBackupInfo;
import aroma1997.backup.common.util.IOHelper;
import aroma1997.backup.standalone.command.Command;
import aroma1997.backup.standalone.command.CommandException;
import aroma1997.backup.standalone.command.CommandRegistry;
import java.io.File;
import java.io.IOException;

public class CommandListParents
extends Command {
    public CommandListParents() {
        super("listParents");
    }

    @Override
    public String getDescr() {
        return this.getName() + " <backup>";
    }

    @Override
    public void execute(String[] args) throws CommandException {
        if (args.length != 1) {
            throw new CommandException("Invalid amount of arguments.");
        }
        IOHelper.printUserOut("The Backup hierarchy (first comes the backup, then follow the parent and the parent's parent and...");
        File file = new File(args[0]);
        try {
            for (ExistingBackupInfo info = new ExistingBackupInfo(file); info != null; info = info.getParent()) {
                IOHelper.printUserOut(CommandRegistry.addEscapes(info.getBackupFile().getCanonicalPath()));
            }
        }
        catch (IOException e) {
            IOHelper.printError("Something went wrong during command execution.");
            e.printStackTrace();
        }
    }
}

