/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import primal_tech.PrimalTech;
import primal_tech.tiles.TileEntityStoneGrill;

public class BlockStoneGrill
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final AxisAlignedBB GRILL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);

    public BlockStoneGrill() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(PrimalTech.TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return GRILL_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return GRILL_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return GRILL_AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean whatIsThis) {
        BlockStoneGrill.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)GRILL_AABB);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityStoneGrill();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        ((TileEntityStoneGrill)world.func_175625_s((BlockPos)pos)).rotation = (byte)(((MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) + 1) % 4);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityStoneGrill tile = (TileEntityStoneGrill)world.func_175625_s(pos);
        if (tile != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tile);
        }
        super.func_180663_b(world, pos, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)FACING);
        ItemStack stack = player.func_184614_ca();
        if (world.func_175625_s(pos) instanceof TileEntityStoneGrill) {
            TileEntityStoneGrill tile = (TileEntityStoneGrill)world.func_175625_s(pos);
            if (side.func_176745_a() == 1) {
                int slotClicked = this.getSlotClicked(direction, hitX, hitZ);
                if (slotClicked == 0 && !player.func_70093_af()) {
                    if (!stack.func_190926_b() && (tile.func_70301_a(slotClicked).func_190926_b() || tile.func_70301_a(slotClicked).func_77973_b() == stack.func_77973_b() && tile.func_70301_a(slotClicked).func_77952_i() == stack.func_77952_i() && tile.func_70301_a(slotClicked).func_190916_E() < 16 && tile.func_70301_a(slotClicked).func_77985_e()) && !world.field_72995_K) {
                        if (!tile.func_70301_a(slotClicked).func_190926_b()) {
                            tile.func_70301_a(slotClicked).func_190917_f(1);
                            stack.func_190918_g(1);
                        } else {
                            tile.func_70299_a(slotClicked, stack.func_77979_a(1));
                        }
                        tile.markForUpdate();
                        return true;
                    }
                } else {
                    ItemStack stack2 = tile.func_70301_a(slotClicked);
                    if (!stack2.func_190926_b()) {
                        float xpCount = FurnaceRecipes.func_77602_a().func_151398_b(stack2);
                        int slotItemCount = stack2.func_190916_E();
                        if (slotClicked == 1) {
                            if (!world.field_72995_K) {
                                if (xpCount == 0.0f) {
                                    slotItemCount = 0;
                                } else if (xpCount < 1.0f) {
                                    int roundedXP = MathHelper.func_76141_d((float)((float)slotItemCount * xpCount));
                                    if (roundedXP < MathHelper.func_76123_f((float)((float)slotItemCount * xpCount)) && Math.random() < (double)((float)slotItemCount * xpCount - (float)roundedXP)) {
                                        ++roundedXP;
                                    }
                                    slotItemCount = roundedXP;
                                }
                                while (slotItemCount > 0) {
                                    int xpSplit = EntityXPOrb.func_70527_a((int)slotItemCount);
                                    slotItemCount -= xpSplit;
                                    EntityXPOrb orb = new EntityXPOrb(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, xpSplit);
                                    world.func_72838_d((Entity)orb);
                                }
                            }
                            slotItemCount = 0;
                        }
                        if (!player.field_71071_by.func_70441_a(stack2)) {
                            ForgeHooks.onPlayerTossEvent((EntityPlayer)player, (ItemStack)stack2.func_77979_a(1), (boolean)false);
                        }
                        world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 2.0f);
                        tile.func_70299_a(slotClicked, stack2);
                    }
                    tile.markForUpdate();
                    return true;
                }
            }
        }
        return true;
    }

    public int getSlotClicked(EnumFacing direction, float hitX, float hitZ) {
        int slot = 3;
        if (hitX > 0.0f && hitX < 0.5f && hitZ > 0.0f && hitZ < 0.5f) {
            if (direction == EnumFacing.NORTH) {
                slot = 1;
            }
            if (direction == EnumFacing.EAST) {
                slot = 1;
            }
            if (direction == EnumFacing.WEST) {
                slot = 0;
            }
            if (direction == EnumFacing.SOUTH) {
                slot = 0;
            }
        }
        if (hitX > 0.5f && hitX < 1.0f && hitZ > 0.0f && hitZ < 0.5f) {
            if (direction == EnumFacing.NORTH) {
                slot = 0;
            }
            if (direction == EnumFacing.EAST) {
                slot = 1;
            }
            if (direction == EnumFacing.WEST) {
                slot = 0;
            }
            if (direction == EnumFacing.SOUTH) {
                slot = 1;
            }
        }
        if (hitX > 0.0f && hitX < 0.5f && hitZ > 0.5f && hitZ < 1.0f) {
            if (direction == EnumFacing.NORTH) {
                slot = 1;
            }
            if (direction == EnumFacing.EAST) {
                slot = 0;
            }
            if (direction == EnumFacing.WEST) {
                slot = 1;
            }
            if (direction == EnumFacing.SOUTH) {
                slot = 0;
            }
        }
        if (hitX > 0.5f && hitX <= 1.0f && hitZ > 0.5f && hitZ < 1.0f) {
            if (direction == EnumFacing.NORTH) {
                slot = 0;
            }
            if (direction == EnumFacing.EAST) {
                slot = 0;
            }
            if (direction == EnumFacing.WEST) {
                slot = 1;
            }
            if (direction == EnumFacing.SOUTH) {
                slot = 1;
            }
        }
        return slot;
    }
}

