/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import primal_tech.ModItems;
import primal_tech.ModSounds;
import primal_tech.PrimalTech;
import primal_tech.configs.ConfigHandler;
import primal_tech.tiles.TileEntityWorkStump;
import primal_tech.tiles.TileEntityWorkStumpUpgraded;

public class BlockWorkStump
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyInteger DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)2);
    public static final AxisAlignedBB JIG_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);

    public BlockWorkStump() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(PrimalTech.TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return JIG_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return JIG_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return JIG_AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean whatIsThis) {
        BlockWorkStump.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)JIG_AABB);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityWorkStump();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf((meta & 0xF) >> 2));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        return meta |= (Integer)state.func_177229_b((IProperty)DAMAGE) << 2;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(meta >> 2));
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityWorkStump tile;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (tile = (TileEntityWorkStump)world.func_175625_s(pos)) instanceof TileEntityWorkStump) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tile);
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                ItemStack itemstack = tile.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                tile.func_70299_a(i, ItemStack.field_190927_a);
            }
            NBTTagCompound nbt = new NBTTagCompound();
            tile.func_189515_b(nbt);
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, this.func_180651_a(state));
            if (tile.getDamage() > 0) {
                stack.func_77982_d(nbt);
            }
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            world.func_175713_t(pos);
        }
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityWorkStump tile;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && stack.func_77942_o() && (tile = (TileEntityWorkStump)world.func_175625_s(pos)) instanceof TileEntityWorkStump) {
            if (stack.func_77978_p().func_74764_b("damage")) {
                tile.setDamage(stack.func_77978_p().func_74762_e("damage"));
                tile.markForUpdate();
            }
            if (!(tile instanceof TileEntityWorkStumpUpgraded) && ConfigHandler.SHOW_BREAKING_WORK_STUMP) {
                if (tile.getDamage() == ConfigHandler.WORK_STUMP_DAMAGE - 2) {
                    state = state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(1));
                    world.func_180501_a(pos, state, 3);
                }
                if (tile.getDamage() == ConfigHandler.WORK_STUMP_DAMAGE - 1) {
                    state = state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(2));
                    world.func_180501_a(pos, state, 3);
                }
            }
            if (tile instanceof TileEntityWorkStumpUpgraded && ConfigHandler.SHOW_BREAKING_WORK_STUMP_II) {
                if (tile.getDamage() == ConfigHandler.WORK_STUMP_II_DAMAGE - 2) {
                    state = state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(1));
                    world.func_180501_a(pos, state, 3);
                }
                if (tile.getDamage() == ConfigHandler.WORK_STUMP_II_DAMAGE - 1) {
                    state = state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(2));
                    world.func_180501_a(pos, state, 3);
                }
            }
        }
        ((TileEntityWorkStump)world.func_175625_s((BlockPos)pos)).rotation = (byte)(((MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) + 1) % 4);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityWorkStump tile = (TileEntityWorkStump)world.func_175625_s(pos);
        if (tile != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tile);
        }
        super.func_180663_b(world, pos, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, DAMAGE});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)FACING);
        ItemStack stack = player.func_184614_ca();
        if (world.func_175625_s(pos) instanceof TileEntityWorkStump) {
            ItemStack stack2;
            TileEntityWorkStump tile = (TileEntityWorkStump)world.func_175625_s(pos);
            if (side.func_176745_a() == 1) {
                this.getSlotClicked(direction, hitX, hitZ);
                if (stack.func_77973_b() != ModItems.ROCK && this.getSlotClicked(direction, hitX, hitZ) != 10) {
                    if (!stack.func_190926_b() && tile.func_70301_a(this.getSlotClicked(direction, hitX, hitZ)).func_190926_b()) {
                        if (!world.field_72995_K) {
                            tile.func_70299_a(this.getSlotClicked(direction, hitX, hitZ), stack.func_77979_a(1));
                            tile.setStrikes(0);
                            tile.markForUpdate();
                            return true;
                        }
                    } else {
                        stack2 = tile.func_70301_a(this.getSlotClicked(direction, hitX, hitZ));
                        if (!stack2.func_190926_b()) {
                            if (!player.field_71071_by.func_70441_a(stack2)) {
                                ForgeHooks.onPlayerTossEvent((EntityPlayer)player, (ItemStack)stack2, (boolean)false);
                            }
                            tile.func_70299_a(this.getSlotClicked(direction, hitX, hitZ), ItemStack.field_190927_a);
                            tile.setStrikes(0);
                            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 2.0f);
                            tile.markForUpdate();
                        }
                    }
                } else if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.ROCK) {
                    tile.setStrikes(tile.getStrikes() + 1);
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    tile.setHit(true);
                    tile.markForUpdate();
                    if (ConfigHandler.SHOW_BREAKING_WORK_STUMP) {
                        if (tile.getDamage() == ConfigHandler.WORK_STUMP_DAMAGE - 2) {
                            state = state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(1));
                            world.func_180501_a(pos, state, 3);
                        }
                        if (tile.getDamage() == ConfigHandler.WORK_STUMP_DAMAGE - 1) {
                            state = state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(2));
                            world.func_180501_a(pos, state, 3);
                        }
                    }
                    if (tile.getDamage() >= ConfigHandler.WORK_STUMP_DAMAGE) {
                        this.func_180663_b(world, pos, state);
                        world.func_175655_b(pos, false);
                        if (player.func_70005_c_().equals("Darkosto")) {
                            world.func_184133_a((EntityPlayer)null, pos, ModSounds.BENTLEY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                        world.func_184133_a((EntityPlayer)null, pos, ModSounds.BREAKING_STUFF, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
            if (side.func_176745_a() != 1 && side.func_176745_a() == direction.func_176745_a()) {
                if (!stack.func_190926_b() && tile.func_70301_a(9).func_190926_b() && stack.func_77973_b() == ModItems.ROCK) {
                    if (!world.field_72995_K) {
                        tile.func_70299_a(9, stack.func_77979_a(1));
                        tile.markForUpdate();
                        return true;
                    }
                } else {
                    stack2 = tile.func_70301_a(9);
                    if (!stack2.func_190926_b()) {
                        if (!player.field_71071_by.func_70441_a(stack2)) {
                            ForgeHooks.onPlayerTossEvent((EntityPlayer)player, (ItemStack)stack2, (boolean)false);
                        }
                        tile.func_70299_a(9, ItemStack.field_190927_a);
                        tile.markForUpdate();
                    }
                }
            }
        }
        return true;
    }

    public int getSlotClicked(EnumFacing direction, float hitX, float hitZ) {
        int slot = 10;
        if (hitX >= 0.4f && hitX <= 0.6f && hitZ >= 0.4f && hitZ <= 0.6f) {
            slot = 4;
        }
        if (hitX >= 0.125f && hitX <= 0.33f && hitZ >= 0.125f && hitZ <= 0.33f) {
            if (direction == EnumFacing.NORTH) {
                slot = 8;
            }
            if (direction == EnumFacing.EAST) {
                slot = 2;
            }
            if (direction == EnumFacing.WEST) {
                slot = 6;
            }
            if (direction == EnumFacing.SOUTH) {
                slot = 0;
            }
        }
        if (hitX >= 0.4f && hitX <= 0.6f && hitZ >= 0.125f && hitZ <= 0.33f) {
            if (direction == EnumFacing.NORTH) {
                slot = 7;
            }
            if (direction == EnumFacing.EAST) {
                slot = 5;
            }
            if (direction == EnumFacing.WEST) {
                slot = 3;
            }
            if (direction == EnumFacing.SOUTH) {
                slot = 1;
            }
        }
        if (hitX >= 0.67f && hitX <= 0.875f && hitZ >= 0.125f && hitZ <= 0.33f) {
            if (direction == EnumFacing.NORTH) {
                slot = 6;
            }
            if (direction == EnumFacing.EAST) {
                slot = 8;
            }
            if (direction == EnumFacing.WEST) {
                slot = 0;
            }
            if (direction == EnumFacing.SOUTH) {
                slot = 2;
            }
        }
        if (hitX >= 0.125f && hitX <= 0.33f && hitZ >= 0.4f && hitZ <= 0.6f) {
            if (direction == EnumFacing.NORTH) {
                slot = 5;
            }
            if (direction == EnumFacing.EAST) {
                slot = 1;
            }
            if (direction == EnumFacing.WEST) {
                slot = 7;
            }
            if (direction == EnumFacing.SOUTH) {
                slot = 3;
            }
        }
        if (hitX >= 0.67f && hitX <= 0.875f && hitZ >= 0.4f && hitZ <= 0.6f) {
            if (direction == EnumFacing.NORTH) {
                slot = 3;
            }
            if (direction == EnumFacing.EAST) {
                slot = 7;
            }
            if (direction == EnumFacing.WEST) {
                slot = 1;
            }
            if (direction == EnumFacing.SOUTH) {
                slot = 5;
            }
        }
        if (hitX >= 0.125f && hitX <= 0.33f && hitZ >= 0.67f && hitZ <= 0.875f) {
            if (direction == EnumFacing.NORTH) {
                slot = 2;
            }
            if (direction == EnumFacing.EAST) {
                slot = 0;
            }
            if (direction == EnumFacing.WEST) {
                slot = 8;
            }
            if (direction == EnumFacing.SOUTH) {
                slot = 6;
            }
        }
        if (hitX >= 0.4f && hitX <= 0.6f && hitZ >= 0.67f && hitZ <= 0.875f) {
            if (direction == EnumFacing.NORTH) {
                slot = 1;
            }
            if (direction == EnumFacing.EAST) {
                slot = 3;
            }
            if (direction == EnumFacing.WEST) {
                slot = 5;
            }
            if (direction == EnumFacing.SOUTH) {
                slot = 7;
            }
        }
        if (hitX >= 0.67f && hitX <= 0.875f && hitZ >= 0.67f && hitZ <= 0.875f) {
            if (direction == EnumFacing.NORTH) {
                slot = 0;
            }
            if (direction == EnumFacing.EAST) {
                slot = 6;
            }
            if (direction == EnumFacing.WEST) {
                slot = 2;
            }
            if (direction == EnumFacing.SOUTH) {
                slot = 8;
            }
        }
        return slot;
    }
}

