/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import primal_tech.ModSounds;
import primal_tech.configs.ConfigHandler;

public class ItemFluidBladder
extends ItemFluidContainer {
    public ItemFluidBladder(int capacity) {
        super(capacity);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Fluid")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"));
            if (fluid != null) {
                list.add(TextFormatting.GREEN + "Contains: " + fluid.getFluid().getLocalizedName(fluid));
                list.add(TextFormatting.BLUE + "" + fluid.amount + "Mb");
            }
        } else {
            list.add(TextFormatting.RED + "It's Empty!");
        }
    }

    public boolean func_77634_r() {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return new ItemStack(stack.func_77973_b(), 1, 0);
    }

    @Nullable
    public static FluidStack getFluid(@Nonnull ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Fluid")) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"));
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p());
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        FluidStack fluidStack = ItemFluidBladder.getFluid(itemstack);
        if (fluidStack == null) {
            RayTraceResult target = this.func_77621_a(world, player, true);
            if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
            }
            BlockPos pos = target.func_178782_a();
            IBlockState iblockstate = world.func_180495_p(pos);
            Material material = iblockstate.func_185904_a();
            if (material == Material.field_151587_i && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && !ConfigHandler.FLUID_BLADDER_LAVA_PICKUP) {
                world.func_184133_a((EntityPlayer)null, pos, ModSounds.CABBAGE_FART, SoundCategory.PLAYERS, 1.0f, 1.0f);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
            }
            FluidActionResult filledResult = FluidUtil.tryPickUpFluid((ItemStack)itemstack, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b);
            if (filledResult.isSuccess()) {
                ItemStack filledStack = filledResult.getResult().func_77946_l();
                filledStack.func_77964_b(1);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)filledStack);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
        }
        if (ConfigHandler.FLUID_BLADDER_PLACES_FLUID) {
            FluidActionResult result;
            BlockPos targetPos;
            RayTraceResult mop = this.func_77621_a(world, player, false);
            if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
            }
            BlockPos clickPos = mop.func_178782_a();
            if (world.func_175660_a(player, clickPos) && player.func_175151_a(targetPos = clickPos.func_177972_a(mop.field_178784_b), mop.field_178784_b, itemstack) && (result = FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)world, (BlockPos)targetPos, (ItemStack)itemstack, (FluidStack)fluidStack)).isSuccess() && !player.field_71075_bZ.field_75098_d) {
                ItemStack emptyStack;
                IBlockState state;
                player.func_71029_a(StatList.func_188057_b((Item)this));
                if (!world.field_72995_K && (state = world.func_180495_p(targetPos)).func_177230_c() instanceof BlockLiquid) {
                    BlockLiquid liquid = (BlockLiquid)state.func_177230_c();
                    BlockDynamicLiquid flowing = BlockLiquid.func_176361_a((Material)state.func_185904_a());
                    world.func_180501_a(targetPos, flowing.func_176223_P(), 11);
                }
                itemstack.func_190918_g(1);
                ItemStack drained = result.getResult();
                ItemStack drainedStack = result.getResult().func_77946_l();
                drainedStack.func_77964_b(0);
                ItemStack itemStack = emptyStack = !drained.func_190926_b() ? drained.func_77946_l() : drainedStack;
                if (itemstack.func_190926_b()) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)drainedStack);
                }
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)drainedStack);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemstack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
    }

    public ICapabilityProvider initCapabilities(final @Nonnull ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemStack.SwapEmpty(stack, stack, this.capacity){

            @Nonnull
            public ItemStack getContainer() {
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Fluid")) {
                    this.container.func_77964_b(1);
                } else {
                    this.container.func_77964_b(0);
                }
                return this.container;
            }

            protected void setContainerToEmpty() {
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Fluid")) {
                    this.container.func_77978_p().func_82580_o("Fluid");
                    this.container.func_77964_b(0);
                } else {
                    this.container.func_77964_b(1);
                }
            }
        };
    }
}

