/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.basic;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.block.ModBlock;
import com.cjm721.overloaded.block.tile.TilePlayerInterface;
import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.client.render.tile.PlayerInterfaceRenderer;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="mcjty.theoneprobe.api.IProbeInfoAccessor", modid="theoneprobe")
public class BlockPlayerInterface
extends ModBlock
implements ITileEntityProvider,
IProbeInfoAccessor {
    public BlockPlayerInterface() {
        super(Material.field_151576_e);
    }

    @Override
    public void baseInit() {
        this.setRegistryName("player_interface");
        this.func_149663_c("player_interface");
        GameRegistry.registerTileEntity(TilePlayerInterface.class, (String)"overloaded:player_interface");
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TilePlayerInterface();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        ((TilePlayerInterface)worldIn.func_175625_s(pos)).setPlacer(placer);
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), null));
        ClientRegistry.bindTileEntitySpecialRenderer(TilePlayerInterface.class, (TileEntitySpecialRenderer)new PlayerInterfaceRenderer());
        ImageUtil.registerDynamicTexture(new ResourceLocation("overloaded", "textures/blocks/block_player.png"), Overloaded.cachedConfig.textureResolutions.blockResolution);
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!worldIn.field_72995_K && hand == EnumHand.MAIN_HAND && (te = worldIn.func_175625_s(pos)) instanceof TilePlayerInterface) {
            UUID placer = ((TilePlayerInterface)te).getPlacer();
            if (placer == null) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Not bound to anyone..... ghosts placed this."));
            } else {
                String username = UsernameCache.getLastKnownUsername((UUID)placer);
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Bound to player: " + (username == null ? placer.toString() : username)));
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te != null && te instanceof TilePlayerInterface) {
            UUID placer = ((TilePlayerInterface)te).getPlacer();
            if (placer == null) {
                probeInfo.text("Not bound to anyone.");
            } else {
                String username = UsernameCache.getLastKnownUsername((UUID)placer);
                probeInfo.text("Bound to player: " + (username == null ? placer.toString() : username));
            }
        }
    }
}

