/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature;

import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.pickletweaks.config.ModConfig;
import java.util.ListIterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class FeatureSwordInfo {
    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (!ModConfig.confSwordInfoTooltip) {
            return;
        }
        DamageSource source = event.getSource();
        Entity entity = source.func_76346_g();
        if (entity != null && entity instanceof EntityPlayer && !(stack = (player = (EntityPlayer)entity).func_184614_ca()).func_190926_b() && stack.func_77973_b() instanceof ItemSword) {
            NBTTagCompound tag = stack.func_190925_c("pickletweaks");
            tag.func_74768_a("EnemiesKilled", tag.func_74762_e("EnemiesKilled") + 1);
        }
    }

    @SubscribeEvent
    public void onEntityDamaged(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (!ModConfig.confSwordInfoTooltip) {
            return;
        }
        DamageSource source = event.getSource();
        Entity entity = source.func_76346_g();
        if (entity != null && entity instanceof EntityPlayer && !(stack = (player = (EntityPlayer)entity).func_184614_ca()).func_190926_b() && stack.func_77973_b() instanceof ItemSword) {
            NBTTagCompound tag = stack.func_190925_c("pickletweaks");
            if (stack.func_77952_i() < stack.func_77958_k() - 1) {
                EntityLivingBase living = event.getEntityLiving();
                if (living.func_110143_aJ() < event.getAmount()) {
                    tag.func_74768_a("DamageDealt", tag.func_74762_e("DamageDealt") + (int)living.func_110143_aJ());
                } else {
                    tag.func_74768_a("DamageDealt", tag.func_74762_e("DamageDealt") + (int)event.getAmount());
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void addSwordInfoTooltip(ItemTooltipEvent event) {
        if (!ModConfig.confSwordInfoTooltip) {
            return;
        }
        ItemStack stack = event.getItemStack();
        ListIterator<String> tooltip = event.getToolTip().listIterator();
        if (stack.func_77973_b() instanceof ItemSword) {
            ItemSword sword = (ItemSword)stack.func_77973_b();
            boolean shift = false;
            if (Keyboard.isCreated()) {
                boolean bl = shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            }
            if (tooltip.hasNext()) {
                tooltip.next();
                if (shift) {
                    tooltip.add(Utils.localize((String)"tooltip.pt.durability") + " " + "\u00a7f" + this.getDurability(stack));
                    tooltip.add(Utils.localize((String)"tooltip.pt.enemies_killed") + " " + "\u00a7f" + this.getEnemiesKilled(stack));
                    tooltip.add(Utils.localize((String)"tooltip.pt.damage_dealt") + " " + "\u00a7f" + this.getDamageDealt(stack));
                } else {
                    tooltip.add(Utils.localize((String)"tooltip.pt.hold_shift_for_info"));
                }
            }
        }
    }

    public String getDurability(ItemStack stack) {
        if (stack.func_77958_k() == -1) {
            return Utils.localize((String)"tooltip.pt.unbreakable");
        }
        int durability = stack.func_77958_k() - stack.func_77952_i();
        return durability + "\u00a77" + "/" + "\u00a7f" + stack.func_77958_k();
    }

    public int getEnemiesKilled(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("pickletweaks");
        if (tag != null && tag.func_74764_b("EnemiesKilled")) {
            return tag.func_74762_e("EnemiesKilled");
        }
        return 0;
    }

    public int getDamageDealt(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("pickletweaks");
        if (tag != null && tag.func_74764_b("DamageDealt")) {
            return tag.func_74762_e("DamageDealt");
        }
        return 0;
    }
}

