/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.reinforcement;

import com.blakebr0.pickletweaks.PickleTweaks;
import com.blakebr0.pickletweaks.config.ModConfig;
import com.blakebr0.pickletweaks.feature.reinforcement.ReinforcementHandler;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;

public class ReinforcementHelper {
    public static void reinforce(ItemStack stack, int reinforce) {
        int current = ReinforcementHelper.getReinforcement(stack);
        int add = Math.min(current + reinforce, ModConfig.confMaxReinforcement);
        PickleTweaks.TAG_HELPER.setInt(stack, "Reinforcement", add);
        if (current == 0) {
            PickleTweaks.TAG_HELPER.setInt(stack, "Damage", stack.func_77952_i());
        }
    }

    public static int useReinforcement(ItemStack stack, int remove) {
        int current = ReinforcementHelper.getReinforcement(stack);
        int remaining = current - remove;
        if (remaining > 0) {
            PickleTweaks.TAG_HELPER.setInt(stack, "Reinforcement", remaining);
        } else {
            PickleTweaks.TAG_HELPER.removeTag(stack, "Reinforcement");
            PickleTweaks.TAG_HELPER.removeTag(stack, "Damage");
        }
        return remaining > 0 ? 0 : -remaining;
    }

    public static int getReinforcement(ItemStack stack) {
        return PickleTweaks.TAG_HELPER.getInt(stack, "Reinforcement");
    }

    public static boolean isReinforced(ItemStack stack) {
        return PickleTweaks.TAG_HELPER.hasKey(stack, "Reinforcement");
    }

    public static int getReinforcementValue(ItemStack stack) {
        for (Map.Entry<ItemStack, Integer> entry : ReinforcementHandler.REINFORCEMENTS.entrySet()) {
            if (!entry.getKey().func_77969_a(stack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static boolean isReinforcement(ItemStack stack) {
        return ReinforcementHandler.REINFORCEMENTS.keySet().stream().anyMatch(o -> o.func_77969_a(stack));
    }

    public static boolean isReinforceable(Item tool) {
        return tool instanceof ItemTool || tool instanceof ItemSword || tool instanceof ItemHoe || tool instanceof ItemBow;
    }

    public static int getDurability(ItemStack stack) {
        return PickleTweaks.TAG_HELPER.getInt(stack, "Damage");
    }
}

