/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.prospectors;

import com.lothrazar.prospectors.Prospectors;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemProspector
extends Item {
    public int cooldown;
    public int range;
    public boolean isBlacklist;
    public String[] blocklist;
    public Prospectors.Types type;

    public ItemProspector(Prospectors.Types t) {
        this.func_77625_d(1);
        this.type = t;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldObj, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (side == null || pos == null) {
            return super.func_180614_a(player, worldObj, pos, hand, side, hitX, hitY, hitZ);
        }
        HashMap<String, Integer> mapList = new HashMap<String, Integer>();
        EnumFacing direction = side.func_176734_d();
        for (int i = 0; i < this.range; ++i) {
            Block blockAt;
            ItemStack s;
            BlockPos current = pos.func_177967_a(direction, i);
            IBlockState at = worldObj.func_180495_p(current);
            if (at == null || at == Blocks.field_150350_a || at.func_177230_c() == null || !this.isBlockShowable(s = new ItemStack(Item.func_150898_a((Block)(blockAt = at.func_177230_c())), 1, blockAt.func_176201_c(at)))) continue;
            String name = s.func_82833_r();
            int previous = mapList.containsKey(name) ? (Integer)mapList.get(name) : 0;
            mapList.put(name, previous + 1);
        }
        if (worldObj.field_72995_K) {
            if (mapList.size() == 0) {
                ItemProspector.addChatMessage(player, ItemProspector.lang("prospector.none") + this.range);
            }
            for (Map.Entry entry : mapList.entrySet()) {
                ItemProspector.addChatMessage(player, ItemProspector.lang("prospector.found") + (String)entry.getKey() + " " + entry.getValue());
            }
        }
        this.onSuccess(player, stack, hand);
        return super.func_180614_a(player, worldObj, pos, hand, side, hitX, hitY, hitZ);
    }

    private void onSuccess(EntityPlayer p, ItemStack s, EnumHand hand) {
        s.func_77972_a(1, (EntityLivingBase)p);
        p.func_184609_a(hand);
        if (this.cooldown > 0) {
            p.func_184811_cZ().func_185145_a(s.func_77973_b(), this.cooldown);
        }
    }

    private static String lang(String string) {
        return I18n.func_74838_a((String)string);
    }

    private static void addChatMessage(EntityPlayer player, String text) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation(ItemProspector.lang(text), new Object[0]));
    }

    private boolean isBlockShowable(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        String itemName = ItemProspector.getStringForItemStack(stack);
        String itemSimpleName = ItemProspector.getStringForItem(stack.func_77973_b());
        boolean isInList = false;
        for (String s : this.blocklist) {
            if (s == null || !s.equals(itemName) && !s.equals(itemSimpleName)) continue;
            isInList = true;
            break;
        }
        boolean yesShowIt = this.isBlacklist ? !isInList : isInList;
        return yesShowIt;
    }

    @Nonnull
    private static String getStringForItemStack(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return item.getRegistryName().func_110624_b() + ":" + item.getRegistryName().func_110623_a() + "/" + itemStack.func_77960_j();
    }

    private static String getStringForItem(Item item) {
        if (item == null || item.getRegistryName() == null) {
            return "";
        }
        return item.getRegistryName().func_110624_b() + ":" + item.getRegistryName().func_110623_a();
    }

    public void syncConfig(Configuration c, String[] deflist) {
        String category = "prospector_" + this.type.name().toLowerCase();
        this.range = c.getInt("range", category, 32, 1, 256, "Search range");
        this.cooldown = c.getInt("cooldown", category, 10, 0, 256, "Time delay per use (ticks); zero to disable");
        this.func_77656_e(c.getInt("durability", category, 200, 1, 65536, "Durability: number of uses"));
        this.isBlacklist = c.getBoolean("IsBlacklist", category, false, "True means this is a blacklist: ignore whats listed. False means its a whitelist: only print whats listed.");
        this.blocklist = c.getStringList("ProspectorBlockList", category, deflist, "List of blocks that the Prospector knows about.");
    }

    public IRecipe addRecipe(ResourceLocation rl) {
        ShapedOreRecipe recipe = null;
        switch (this.type) {
            case LOWEST: {
                recipe = new ShapedOreRecipe(rl, new ItemStack((Item)this), new Object[]{" sg", " bs", "b  ", Character.valueOf('b'), "cobblestone", Character.valueOf('s'), "stickWood", Character.valueOf('g'), "logWood"});
                break;
            }
            case LOW: {
                recipe = new ShapedOreRecipe(rl, new ItemStack((Item)this), new Object[]{" sg", " bs", "b  ", Character.valueOf('b'), "logWood", Character.valueOf('s'), Items.field_151044_h, Character.valueOf('g'), "blockGlassColorless"});
                break;
            }
            case MED: {
                recipe = new ShapedOreRecipe(rl, new ItemStack((Item)this), new Object[]{" sg", " bs", "b  ", Character.valueOf('b'), "gemLapis", Character.valueOf('s'), "dustRedstone", Character.valueOf('g'), "blockGlassColorless"});
                break;
            }
            case HIGH: {
                recipe = new ShapedOreRecipe(rl, new ItemStack((Item)this), new Object[]{" sg", " bs", "b  ", Character.valueOf('b'), "gemEmerald", Character.valueOf('s'), "dustRedstone", Character.valueOf('g'), "blockGlassColorless"});
                break;
            }
            case BEST: {
                recipe = new ShapedOreRecipe(rl, new ItemStack((Item)this), new Object[]{" sg", " bs", "b  ", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('s'), "gemDiamond", Character.valueOf('g'), "blockGlassColorless"});
            }
        }
        recipe.setRegistryName(rl);
        return recipe;
    }
}

