/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.prospectors;

import com.lothrazar.prospectors.CommonProxy;
import com.lothrazar.prospectors.ItemProspector;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="prospectors", updateJSON="https://raw.githubusercontent.com/PrinceOfAmber/Prospectors/master/update.json", guiFactory="com.lothrazar.prospectors.IngameConfigFactory", acceptedMinecraftVersions="[1.12]")
public class Prospectors {
    @Mod.Instance(value="prospectors")
    public static Prospectors instance;
    @SidedProxy(clientSide="com.lothrazar.prospectors.ClientProxy", serverSide="com.lothrazar.prospectors.CommonProxy")
    public static CommonProxy proxy;
    public static final String MODID = "prospectors";
    private List<Item> items = new ArrayList<Item>();
    private List<IRecipe> recipes = new ArrayList<IRecipe>();
    public static final CreativeTabs TAB;
    public static final ItemProspector lowest;
    public static final ItemProspector low;
    public static final ItemProspector med;
    public static final ItemProspector high;
    public static final ItemProspector best;
    static Configuration config;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.syncAllConfig();
        this.register(lowest, "prospector_" + Prospectors.lowest.type.name().toLowerCase());
        this.register(low, "prospector_" + Prospectors.low.type.name().toLowerCase());
        this.register(med, "prospector_" + Prospectors.med.type.name().toLowerCase());
        this.register(high, "prospector_" + Prospectors.high.type.name().toLowerCase());
        this.register(best, "prospector_" + Prospectors.best.type.name().toLowerCase());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void register(ItemProspector item, String key) {
        item.func_77655_b(key);
        item.func_77637_a(TAB);
        ResourceLocation rl = new ResourceLocation(MODID, key);
        item.setRegistryName(rl);
        this.items.add(item);
        this.addRecipe(item.addRecipe(rl));
    }

    private void addRecipe(IRecipe r) {
        this.recipes.add(r);
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.items.toArray(new Item[0]));
    }

    @SubscribeEvent
    public void onRegisterRecipe(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.recipes.toArray(new IRecipe[0]));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (Item item : this.items) {
            String name = "prospectors:" + item.func_77658_a().replaceAll("item.", "");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            this.syncAllConfig();
        }
    }

    private void syncAllConfig() {
        lowest.syncConfig(config, new String[]{"minecraft:coal_ore", "minecraft:gravel", "minecraft:sand"});
        low.syncConfig(config, new String[]{"minecraft:iron_ore", "minecraft:coal_ore"});
        med.syncConfig(config, new String[]{"minecraft:gold_ore", "minecraft:iron_ore", "minecraft:coal_ore", "minecraft:lapis_ore"});
        high.syncConfig(config, new String[]{"minecraft:quartz_ore", "minecraft:iron_ore", "minecraft:gold_ore", "minecraft:iron_ore", "minecraft:coal_ore", "minecraft:lapis_ore", "minecraft:redstone_ore/0", "minecraft:redstone_ore/1"});
        best.syncConfig(config, new String[]{"minecraft:quartz_ore", "minecraft:diamond_ore", "minecraft:emerald_ore", "minecraft:iron_ore", "minecraft:gold_ore", "minecraft:iron_ore", "minecraft:coal_ore", "minecraft:lapis_ore", "minecraft:redstone_ore/0", "minecraft:redstone_ore/1"});
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        TAB = new CreativeTabs(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack(Items.field_151045_i);
            }
        };
        lowest = new ItemProspector(Types.LOWEST);
        low = new ItemProspector(Types.LOW);
        med = new ItemProspector(Types.MED);
        high = new ItemProspector(Types.HIGH);
        best = new ItemProspector(Types.BEST);
    }

    public static enum Types {
        LOWEST,
        LOW,
        MED,
        HIGH,
        BEST;

    }
}

