/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.blocks;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.blocks.Types;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockOreVanilla
extends Block {
    public static final PropertyEnum<Types.Vanilla> VARIANT = PropertyEnum.func_177709_a((String)"variant", Types.Vanilla.class);

    public BlockOreVanilla() {
        super(Material.field_151576_e);
        this.setRegistryName(new ResourceLocation("geolosys", "ore_vanilla"));
        this.func_149711_c(7.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Types.Vanilla.COAL)));
        this.func_149663_c(this.getRegistryName().toString().replaceAll(":", "."));
        this.setHarvestLevels();
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)new ItemBlockOre(this));
        this.registerOreDict();
    }

    private void registerOreDict() {
        for (int i = 0; i < Types.Vanilla.values().length; ++i) {
            OreDictionary.registerOre((String)("oreBlock" + Types.Vanilla.values()[i].func_176610_l().substring(0, 1).toUpperCase() + Types.Vanilla.values()[i].func_176610_l().substring(1)), (ItemStack)new ItemStack((Block)this, 1, i));
        }
    }

    private void setHarvestLevels() {
        for (Types.Vanilla t : Types.Vanilla.values()) {
            this.setHarvestLevel("pickaxe", t.getToolLevel(), this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)t)));
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    private ItemStack getQuartzSilkTouchDrop() {
        Random random = new Random();
        int rng = random.nextInt(25);
        if (OreDictionary.doesOreNameExist((String)"oreCertusQuartz") && OreDictionary.getOres((String)"oreCertusQuartz").size() > 0 && rng < 7) {
            ItemStack oreCert = (ItemStack)OreDictionary.getOres((String)"oreCertusQuartz").get(0);
            oreCert = oreCert.func_77946_l();
            oreCert.func_190920_e(1);
            return oreCert;
        }
        if (OreDictionary.doesOreNameExist((String)"oreQuartzBlack") && OreDictionary.getOres((String)"oreQuartzBlack").size() > 0 && rng >= 7 && rng < 12) {
            ItemStack oreBlack = (ItemStack)OreDictionary.getOres((String)"oreQuartzBlack").get(0);
            oreBlack = oreBlack.func_77946_l();
            oreBlack.func_190920_e(1);
            return oreBlack;
        }
        return new ItemStack(Blocks.field_150449_bY, 1);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        switch (this.field_176227_L.func_177622_c().func_176201_c(state)) {
            case 0: {
                return new ItemStack(Blocks.field_150365_q, 1);
            }
            case 1: {
                return new ItemStack(Blocks.field_150450_ax, 1);
            }
            case 2: {
                return new ItemStack(Blocks.field_150352_o, 1);
            }
            case 3: {
                return new ItemStack(Blocks.field_150369_x, 1);
            }
            case 4: {
                return this.getQuartzSilkTouchDrop();
            }
            case 5: {
                return new ItemStack(Blocks.field_150482_ag, 1);
            }
            case 6: {
                return new ItemStack(Blocks.field_150412_bA, 1);
            }
        }
        return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random random = new Random();
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == 0) {
            int rng;
            drops.add((Object)new ItemStack(Blocks.field_150365_q.func_180660_a(state, random, fortune), Blocks.field_150365_q.func_149679_a(fortune, random), Blocks.field_150365_q.func_180651_a(state)));
            if (ModConfig.featureControl.enableCoals) {
                Item coal = Geolosys.getInstance().COAL;
                int y = pos.func_177956_o();
                int rng2 = random.nextInt(10) + fortune;
                if (y <= 12) {
                    if (rng2 > 5) {
                        drops.add((Object)new ItemStack(coal, 1, 3));
                    }
                } else if (y <= 24) {
                    if (rng2 > 5) {
                        drops.add((Object)new ItemStack(coal, 1, 2));
                    }
                } else if (y < 36) {
                    if (rng2 > 5) {
                        drops.add((Object)new ItemStack(coal, 1, 1));
                    }
                } else if (y < 48 && rng2 > 5) {
                    drops.add((Object)new ItemStack(coal, 1, 0));
                }
            }
            if (ModConfig.featureControl.enableSulfur && OreDictionary.doesOreNameExist((String)"dustSulfur") && OreDictionary.getOres((String)"dustSulfur").size() > 0 && (rng = random.nextInt(50)) == 0) {
                drops.add(OreDictionary.getOres((String)"dustSulfur").get(0));
            }
        } else if (meta == 1) {
            drops.add((Object)new ItemStack(Blocks.field_150450_ax.func_180660_a(state, random, fortune), Blocks.field_150450_ax.func_149679_a(fortune, random), Blocks.field_150450_ax.func_180651_a(state)));
        } else if (meta == 2) {
            drops.add((Object)new ItemStack(Geolosys.getInstance().CLUSTER, 1, 1));
        } else if (meta == 3) {
            drops.add((Object)new ItemStack(Blocks.field_150369_x.func_180660_a(state, random, fortune), Blocks.field_150369_x.func_149679_a(fortune, random), Blocks.field_150369_x.func_180651_a(state)));
        } else if (meta == 4) {
            drops.add((Object)new ItemStack(Blocks.field_150449_bY.func_180660_a(state, random, fortune), Blocks.field_150449_bY.func_149679_a(fortune, random), Blocks.field_150449_bY.func_180651_a(state)));
        } else if (meta == 5) {
            drops.add((Object)new ItemStack(Blocks.field_150482_ag.func_180660_a(state, random, fortune), Blocks.field_150482_ag.func_149679_a(fortune, random), Blocks.field_150482_ag.func_180651_a(state)));
        } else if (meta == 6) {
            drops.add((Object)new ItemStack(Blocks.field_150412_bA.func_180660_a(state, random, fortune), Blocks.field_150412_bA.func_149679_a(fortune, random), Blocks.field_150412_bA.func_180651_a(state)));
        }
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        switch (state.func_177230_c().func_176201_c(state)) {
            case 0: {
                return Blocks.field_150365_q.getExpDrop(state, world, pos, fortune);
            }
            case 1: {
                return Blocks.field_150450_ax.getExpDrop(state, world, pos, fortune);
            }
            case 3: {
                return Blocks.field_150369_x.getExpDrop(state, world, pos, fortune);
            }
            case 4: {
                return Blocks.field_150449_bY.getExpDrop(state, world, pos, fortune);
            }
            case 5: {
                return Blocks.field_150482_ag.getExpDrop(state, world, pos, fortune);
            }
            case 6: {
                return Blocks.field_150412_bA.getExpDrop(state, world, pos, fortune);
            }
        }
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(state.func_177230_c(), 1, this.func_176201_c(state));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Types.Vanilla.byMetadata(meta)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Types.Vanilla.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Types.Vanilla)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public class ItemBlockOre
    extends ItemBlock {
        ItemBlockOre(Block block) {
            super(block);
            this.func_77627_a(true);
            this.setRegistryName(block.getRegistryName());
            this.func_77656_e(0);
            this.registerModels();
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public String func_77667_c(ItemStack stack) {
            return stack.func_77973_b().getRegistryName().toString().replaceAll(":", ".") + "." + Types.Vanilla.byMetadata(stack.func_77960_j()).func_176610_l();
        }

        @SideOnly(value=Side.CLIENT)
        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
            if (this.func_194125_a(tab)) {
                for (int i = 0; i < Types.Vanilla.values().length; ++i) {
                    list.add((Object)new ItemStack((Item)this, 1, i));
                }
            }
        }

        private void registerModels() {
            for (int i = 0; i < Types.Vanilla.values().length; ++i) {
                Geolosys.getInstance().clientRegistry.register(new ItemStack((Item)this, 1, i), VARIANT.func_177701_a() + "=" + Types.Vanilla.byMetadata(i).func_176610_l());
            }
        }
    }
}

