/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;

public class ConfigOres {
    public Ore coal;
    public Ore cinnabar;
    public Ore gold;
    public Ore lapis;
    public Ore quartz;
    public Ore kimberlite;
    public Ore beryl;
    public Ore hematite;
    public Ore limonite;
    public Ore malachite;
    public Ore azurite;
    public Ore cassiterite;
    public Ore teallite;
    public Ore galena;
    public Ore bauxite;
    public Ore platinum;
    public Ore autunite;
    public Ore sphalerite;

    public void populateConfigs() {
        this.coal = new Ore(8, 78, 8, 64, new int[]{-1, 1});
        this.cinnabar = new Ore(5, 12, 6, 40, new int[]{-1, 1});
        this.gold = new Ore(5, 30, 4, 40, new int[]{-1, 1});
        this.lapis = new Ore(10, 24, 5, 32, new int[]{-1, 1});
        this.quartz = new Ore(6, 29, 6, 40, new int[]{-1, 1});
        this.kimberlite = new Ore(2, 15, 3, 20, new int[]{-1, 1});
        this.beryl = new Ore(4, 32, 3, 16, new int[]{-1, 1});
        this.hematite = new Ore(32, 60, 6, 24, new int[]{-1, 1});
        this.limonite = new Ore(6, 32, 5, 80, new int[]{-1, 1});
        this.malachite = new Ore(39, 44, 6, 24, new int[]{-1, 1});
        this.azurite = new Ore(12, 44, 5, 80, new int[]{-1, 1});
        this.cassiterite = new Ore(44, 68, 6, 24, new int[]{-1, 1});
        this.teallite = new Ore(8, 43, 5, 80, new int[]{-1, 1});
        this.galena = new Ore(16, 50, 5, 72, new int[]{-1, 1});
        this.bauxite = new Ore(45, 70, 4, 64, new int[]{-1, 1});
        this.platinum = new Ore(3, 25, 4, 32, new int[]{-1, 1});
        this.autunite = new Ore(8, 33, 5, 24, new int[]{-1, 1});
        this.sphalerite = new Ore(35, 55, 4, 24, new int[]{-1, 1});
    }

    public void validate(File configDir) {
        boolean dirty = false;
        for (Field f : this.getClass().getFields()) {
            try {
                Field field = this.getClass().getField(f.getName());
                Ore val = (Ore)field.get(this);
                if (val != null) continue;
                f.set(this, new Ore(0, 0, 0, 0, new int[0]));
                dirty = true;
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (dirty) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((Object)this);
            try {
                FileWriter fw = new FileWriter(configDir.getAbsolutePath() + "/geolosys_ores.json".replace("/", File.separator));
                fw.write(json);
                fw.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static class Ore {
        private int minY;
        private int maxY;
        private int chance;
        private int size;
        private int[] blacklist;

        public Ore(int minY, int maxY, int chance, int size, int[] blacklist) {
            this.minY = minY;
            this.maxY = maxY;
            this.chance = chance;
            this.size = size;
            this.blacklist = blacklist;
        }

        public int getMinY() {
            return this.minY;
        }

        public int getMaxY() {
            return this.maxY;
        }

        public int getChance() {
            return this.chance;
        }

        public int getSize() {
            return this.size;
        }

        public int[] getBlacklist() {
            return this.blacklist;
        }
    }
}

