/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.common.api.GeolosysAPI;
import com.oitsjustjose.geolosys.common.blocks.BlockSample;
import com.oitsjustjose.geolosys.common.blocks.BlockSampleVanilla;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;

public class ChunkData {
    private Random random = new Random();

    public void addChunk(ChunkPos pos, World world, IBlockState state, int depositHeight) {
        if (world.func_175624_G() == WorldType.field_77138_c) {
            return;
        }
        int cap = this.getSampleCount(state);
        for (int i = 0; i < cap; ++i) {
            BlockPos p = this.getSamplePos(world, pos, depositHeight);
            if (world.func_180495_p(p.func_177977_b()).func_177230_c() instanceof BlockSample || world.func_180495_p(p.func_177977_b()).func_177230_c() instanceof BlockSampleVanilla || !ModConfig.prospecting.generateInWater && this.isMoist(world, p)) continue;
            world.func_180501_a(p.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 18);
            world.func_180501_a(p, state, 18);
        }
    }

    public boolean canGenerateInChunk(World world, ChunkPos pos, int dimension) {
        return dimension == -9999 || !GeolosysAPI.getCurrentWorldDeposits().keySet().contains(new GeolosysAPI.ChunkPosSerializable(pos, dimension));
    }

    private BlockPos getSamplePos(World world, ChunkPos chunkPos, int depositHeight) {
        int blockPosX = (chunkPos.field_77276_a << 4) + this.random.nextInt(16);
        int blockPosZ = (chunkPos.field_77275_b << 4) + this.random.nextInt(16);
        BlockPos searchPos = new BlockPos(blockPosX, 0, blockPosZ);
        while (searchPos.func_177956_o() < world.func_72800_K()) {
            if (world.func_180495_p(searchPos.func_177977_b()).isSideSolid((IBlockAccess)world, searchPos.func_177977_b(), EnumFacing.UP) && this.canReplace(world, searchPos) && this.canReplace(world, searchPos.func_177984_a())) {
                if (searchPos.func_177956_o() > world.func_181545_F()) {
                    return searchPos;
                }
                if (this.isWithinRange(world.func_181545_F(), searchPos.func_177956_o(), 12) && searchPos.func_177956_o() < depositHeight) {
                    return searchPos;
                }
            }
            searchPos = searchPos.func_177984_a();
        }
        return world.func_175672_r(searchPos);
    }

    private boolean canReplace(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Material mat = state.func_185904_a();
        return mat == Material.field_151579_a || mat == Material.field_151585_k || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c().isFoliage((IBlockAccess)world, pos) || mat.func_76222_j();
    }

    private boolean isWithinRange(int posA, int posB, int range) {
        return Math.abs(posA - posB) <= range;
    }

    private boolean isMoist(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d() || world.func_180495_p(pos.func_177974_f()).func_185904_a().func_76224_d() || world.func_180495_p(pos.func_177976_e()).func_185904_a().func_76224_d() || world.func_180495_p(pos.func_177978_c()).func_185904_a().func_76224_d() || world.func_180495_p(pos.func_177968_d()).func_185904_a().func_76224_d();
    }

    private int getSampleCount(IBlockState state) {
        int count = GeolosysAPI.sampleCounts.get(state) / ModConfig.prospecting.maxSamples;
        if (count > ModConfig.prospecting.maxSamples) {
            count = ModConfig.prospecting.maxSamples;
        }
        return count;
    }
}

