/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.api.GeolosysAPI;
import com.oitsjustjose.geolosys.common.world.ToDoBlocks;
import com.oitsjustjose.geolosys.common.world.WorldGenMinableSafe;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.IWorldGenerator;

public class StoneGenerator
implements IWorldGenerator {
    private static final List<IBlockState> blockStateMatchers = GeolosysAPI.replacementMats;
    private static final String dataID = "geolosysStoneGeneratorPending";
    private static HashMap<Integer, StoneGen> stoneSpawnWeights = new HashMap();
    private static int last = 0;

    public static void addStoneGen(IBlockState state, int minY, int maxY, int weight) {
        StoneGen gen = new StoneGen(state, minY, maxY, weight);
        for (int i = last; i < last + weight; ++i) {
            stoneSpawnWeights.put(i, gen);
        }
        last += weight;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        ToDoBlocks.getForWorld(world, dataID).processPending(new ChunkPos(chunkX, chunkZ), world, blockStateMatchers);
        if (world.field_73011_w.getDimension() == 1 || world.field_73011_w.getDimension() == -1) {
            return;
        }
        if (stoneSpawnWeights.keySet().size() > 0) {
            int rng = random.nextInt(stoneSpawnWeights.keySet().size());
            stoneSpawnWeights.get(rng).generate(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    public static class StoneGen {
        WorldGenMinableSafe pluton;
        IBlockState state;
        int minY;
        int maxY;
        int weight;

        StoneGen(IBlockState state, int minY, int maxY, int weight) {
            this.pluton = new WorldGenMinableSafe(state, 96, blockStateMatchers, StoneGenerator.dataID);
            this.state = state;
            this.minY = Math.min(minY, maxY);
            this.maxY = Math.max(minY, maxY);
            this.weight = weight;
        }

        public void generate(World world, Random rand, int x, int z) {
            if (!Geolosys.getInstance().chunkOreGen.canGenerateInChunk(world, new ChunkPos(x / 16, z / 16), world.field_73011_w.getDimension())) {
                return;
            }
            boolean lastState = ForgeModContainer.logCascadingWorldGeneration;
            ForgeModContainer.logCascadingWorldGeneration = false;
            if (rand.nextInt(100) < this.weight) {
                int y = this.minY != this.maxY ? this.minY + rand.nextInt(this.maxY - this.minY) : this.minY;
                this.pluton.func_180709_b(world, rand, new BlockPos(x, y, z));
            }
            ForgeModContainer.logCascadingWorldGeneration = lastState;
        }
    }
}

