/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.common.util.Utils;
import com.oitsjustjose.geolosys.common.world.ToDoBlocks;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMinableSafe
extends WorldGenerator {
    private final IBlockState oreBlock;
    private final int numberOfBlocks;
    private final List<IBlockState> matchers;
    private String dataName;

    public WorldGenMinableSafe(IBlockState state, int blockCount, List<IBlockState> matchers, String dataName) {
        this.oreBlock = state;
        this.numberOfBlocks = blockCount;
        this.matchers = matchers;
        this.dataName = dataName;
    }

    private boolean isInChunk(ChunkPos chunkPos, BlockPos pos) {
        int blockX = pos.func_177958_n();
        int blockZ = pos.func_177952_p();
        return blockX >= chunkPos.func_180334_c() && blockX <= chunkPos.func_180332_e() && blockZ >= chunkPos.func_180333_d() && blockZ <= chunkPos.func_180330_f();
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        float f = rand.nextFloat() * (float)Math.PI;
        double d0 = (float)(position.func_177958_n() + 8) + MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks / 8.0f;
        double d1 = (float)(position.func_177958_n() + 8) - MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks / 8.0f;
        double d2 = (float)(position.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks / 8.0f;
        double d3 = (float)(position.func_177952_p() + 8) - MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks / 8.0f;
        double d4 = position.func_177956_o() + rand.nextInt(3) - 2;
        double d5 = position.func_177956_o() + rand.nextInt(3) - 2;
        ToDoBlocks toDoBlocks = ToDoBlocks.getForWorld(worldIn, this.dataName);
        ChunkPos thisChunk = new ChunkPos(position);
        boolean placedOre = false;
        for (int i = 0; i < this.numberOfBlocks; ++i) {
            float f1 = (float)i / (float)this.numberOfBlocks;
            double d6 = d0 + (d1 - d0) * (double)f1;
            double d7 = d4 + (d5 - d4) * (double)f1;
            double d8 = d2 + (d3 - d2) * (double)f1;
            double d9 = rand.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            int j = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int k = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int l = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int i1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int l1 = j; l1 <= i1; ++l1) {
                double d12 = ((double)l1 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int i2 = k; i2 <= j1; ++i2) {
                    double d13 = ((double)i2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    block3: for (int j2 = l; j2 <= k1; ++j2) {
                        double d14 = ((double)j2 + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0)) continue;
                        BlockPos blockpos = new BlockPos(l1, i2, j2);
                        if (this.isInChunk(thisChunk, blockpos) || worldIn.func_190526_b(l1 >> 4, j2 >> 4)) {
                            IBlockState state = worldIn.func_180495_p(blockpos);
                            if (state == null) continue;
                            for (IBlockState iBlockState : this.matchers) {
                                if (!Utils.doStatesMatch(iBlockState, state)) continue;
                                worldIn.func_180501_a(blockpos, this.oreBlock, 18);
                                placedOre = true;
                                continue block3;
                            }
                            continue;
                        }
                        toDoBlocks.storePending(blockpos, this.oreBlock);
                    }
                }
            }
        }
        return placedOre;
    }
}

