/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.api.transport.pipe.EnumPipeColourType;
import buildcraft.api.transport.pipe.IItemPipe;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.api.transport.pipe.PipeFaceTex;
import buildcraft.lib.client.model.ModelItemSimple;
import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.SpriteUtil;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.client.model.PipeModelCacheBase;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public final class ModelPipeItem
extends Enum<ModelPipeItem>
implements IBakedModel {
    public static final /* enum */ ModelPipeItem INSTANCE;
    private static final MutableQuad[] QUADS_SAME;
    private static final MutableQuad[] QUADS_COLOUR;
    private static final /* synthetic */ ModelPipeItem[] $VALUES;

    public static ModelPipeItem[] values() {
        return (ModelPipeItem[])$VALUES.clone();
    }

    public static ModelPipeItem valueOf(String name) {
        return Enum.valueOf(ModelPipeItem.class, name);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return ImmutableList.of();
    }

    private static List<BakedQuad> getQuads(PipeFaceTex center, PipeFaceTex top, PipeFaceTex bottom, TextureAtlasSprite[] sprites, int colour, EnumPipeColourType colourType) {
        top = center;
        bottom = center;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        ModelPipeItem.addQuads(QUADS_SAME, sprites, quads, center);
        if (colour > 0 && colour <= 16) {
            EnumDyeColor rColour = EnumDyeColor.func_176764_b((int)(colour - 1));
            int rgb = 0xFF000000 | ColourUtil.swapArgbToAbgr((int)ColourUtil.getLightHex((EnumDyeColor)rColour));
            if (colourType == EnumPipeColourType.TRANSLUCENT) {
                TextureAtlasSprite sprite = BCTransportSprites.PIPE_COLOUR.getSprite();
                ModelPipeItem.addQuadsColoured(QUADS_COLOUR, quads, sprite, rgb);
            } else if (colourType == EnumPipeColourType.BORDER_OUTER) {
                TextureAtlasSprite sprite = BCTransportSprites.PIPE_COLOUR_BORDER_OUTER.getSprite();
                ModelPipeItem.addQuadsColoured(QUADS_SAME, quads, sprite, rgb);
            } else if (colourType == EnumPipeColourType.BORDER_INNER) {
                TextureAtlasSprite sprite = BCTransportSprites.PIPE_COLOUR_BORDER_INNER.getSprite();
                ModelPipeItem.addQuadsColoured(QUADS_SAME, quads, sprite, rgb);
            }
        }
        return quads;
    }

    private static void addQuads(MutableQuad[] from, TextureAtlasSprite[] sprites, List<BakedQuad> to, PipeFaceTex face) {
        MutableQuad copy = new MutableQuad();
        for (int i = 0; i < face.getCount(); ++i) {
            int colour = face.getColour(i);
            int spriteIndex = face.getTexture(i);
            TextureAtlasSprite sprite = ModelPipeItem.getSprite(sprites, spriteIndex);
            for (MutableQuad f : from) {
                if (f == null) continue;
                copy.copyFrom(f);
                copy.texFromSprite(sprite);
                copy.colouri(colour);
                to.add(copy.toBakedItem());
            }
        }
    }

    private static TextureAtlasSprite getSprite(TextureAtlasSprite[] sprites, int spriteIndex) {
        TextureAtlasSprite sprite = spriteIndex < 0 || spriteIndex >= sprites.length ? SpriteUtil.missingSprite() : sprites[spriteIndex];
        return sprite;
    }

    private static void addQuadsColoured(MutableQuad[] from, List<BakedQuad> to, TextureAtlasSprite sprite, int colour) {
        for (MutableQuad f : from) {
            if (f == null) continue;
            MutableQuad copy = new MutableQuad(f);
            copy.texFromSprite(sprite);
            copy.colouri(colour);
            to.add(copy.toBakedItem());
        }
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return PipeItemOverride.PIPE_OVERRIDE;
    }

    static {
        ModelUtil.UvFaceData uvs;
        INSTANCE = new ModelPipeItem();
        $VALUES = new ModelPipeItem[]{INSTANCE};
        QUADS_SAME = new MutableQuad[6];
        Point3f center = new Point3f(0.5f, 0.5f, 0.5f);
        Vector3f radius = new Vector3f(0.25f, 0.5f, 0.25f);
        ModelUtil.UvFaceData uvsY = ModelUtil.UvFaceData.from16((int)4, (int)4, (int)12, (int)12);
        ModelUtil.UvFaceData uvsXZ = ModelUtil.UvFaceData.from16((int)4, (int)0, (int)12, (int)16);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            uvs = face.func_176740_k() == EnumFacing.Axis.Y ? uvsY : uvsXZ;
            ModelPipeItem.QUADS_SAME[face.ordinal()] = ModelUtil.createFace((EnumFacing)face, (Tuple3f)center, (Tuple3f)radius, (ModelUtil.UvFaceData)uvs);
        }
        QUADS_COLOUR = new MutableQuad[6];
        center = new Point3f(0.5f, 0.5f, 0.5f);
        radius = new Vector3f(0.24f, 0.49f, 0.24f);
        uvsY = ModelUtil.UvFaceData.from16((int)4, (int)4, (int)12, (int)12);
        uvsXZ = ModelUtil.UvFaceData.from16((int)4, (int)0, (int)12, (int)16);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            uvs = face.func_176740_k() == EnumFacing.Axis.Y ? uvsY : uvsXZ;
            ModelPipeItem.QUADS_COLOUR[face.ordinal()] = ModelUtil.createFace((EnumFacing)face, (Tuple3f)center, (Tuple3f)radius, (ModelUtil.UvFaceData)uvs);
        }
    }

    private static class PipeItemOverride
    extends ItemOverrideList {
        public static final PipeItemOverride PIPE_OVERRIDE = new PipeItemOverride();

        public PipeItemOverride() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            EnumPipeColourType type;
            PipeFaceTex center;
            Item item = stack.func_77973_b();
            PipeFaceTex top = center = PipeFaceTex.NO_SPRITE;
            PipeFaceTex bottom = center;
            TextureAtlasSprite[] sprites = new TextureAtlasSprite[]{SpriteUtil.missingSprite()};
            if (item instanceof IItemPipe) {
                PipeDefinition def = ((IItemPipe)item).getDefinition();
                top = def.itemModelTop;
                center = def.itemModelCenter;
                bottom = def.itemModelBottom;
                type = def.getColourType();
                sprites = PipeModelCacheBase.generator.getItemSprites(def);
            } else {
                type = EnumPipeColourType.TRANSLUCENT;
            }
            List quads = ModelPipeItem.getQuads(center, top, bottom, sprites, stack.func_77960_j(), type);
            return new ModelItemSimple(quads, ModelItemSimple.TRANSFORM_BLOCK, true);
        }
    }
}

