/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.api.core.BCLog;
import buildcraft.api.transport.pipe.EnumPipeColourType;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.api.transport.pipe.PipeFaceTex;
import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.sprite.AtlasSpriteVariants;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.client.model.IPipeBaseModelGen;
import buildcraft.transport.client.model.PipeModelCacheBase;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public enum PipeBaseModelGenStandard implements IPipeBaseModelGen
{
    INSTANCE;

    private static final Map<PipeDefinition, TextureAtlasSprite[]> SPRITES;
    private static final MutableQuad[][][] QUADS;
    private static final MutableQuad[][][] QUADS_COLOURED;

    @Override
    public void onTextureStitchPre(TextureMap map) {
        SPRITES.clear();
        HashMap<String, TextureAtlasSprite> sprites = new HashMap<String, TextureAtlasSprite>();
        for (PipeDefinition def : PipeApi.pipeRegistry.getAllRegisteredPipes()) {
            TextureAtlasSprite[] array = new TextureAtlasSprite[def.textures.length];
            for (int i = 0; i < array.length; ++i) {
                String name = def.textures[i];
                TextureAtlasSprite sprite = (TextureAtlasSprite)sprites.get(name);
                if (sprite == null) {
                    sprite = map.getTextureExtry(name);
                    if (sprite == null) {
                        sprite = AtlasSpriteVariants.createForConfig((ResourceLocation)new ResourceLocation(name));
                        map.setTextureEntry(sprite);
                    } else {
                        BCLog.logger.warn("Couldn't override " + name + ", using existing sprite " + sprite.getClass());
                    }
                    sprites.put(name, sprite);
                }
                array[i] = sprite;
            }
            SPRITES.put(def, array);
        }
    }

    @Override
    public TextureAtlasSprite[] getItemSprites(PipeDefinition def) {
        return SPRITES.get(def);
    }

    private static void dupDarker(MutableQuad[] quads) {
        int halfLength = quads.length / 2;
        float mult = OPTION_INSIDE_COLOUR_MULT.getAsFloat();
        for (int i = 0; i < halfLength; ++i) {
            int n = i + halfLength;
            MutableQuad from = quads[i];
            if (from == null) continue;
            MutableQuad to = from.copyAndInvertNormal();
            to.setCalculatedDiffuse();
            to.multColourd((double)mult);
            quads[n] = to;
        }
    }

    private static void dupInverted(MutableQuad[] quads) {
        int halfLength = quads.length / 2;
        for (int i = 0; i < halfLength; ++i) {
            int n = i + halfLength;
            MutableQuad from = quads[i];
            if (from == null) continue;
            quads[n] = from.copyAndInvertNormal();
        }
    }

    @Override
    public List<BakedQuad> generateCutout(PipeModelCacheBase.PipeBaseCutoutKey key) {
        ArrayList<MutableQuad> quads = new ArrayList<MutableQuad>();
        TextureAtlasSprite[] spriteArray = SPRITES.get(key.definition);
        TextureAtlasSprite borderSprite = PipeBaseModelGenStandard.getBorderSprite(key);
        int colour = borderSprite == null ? -1 : PipeBaseModelGenStandard.getPipeModelColour(key.colour);
        int border_r = colour >> 0 & 0xFF;
        int border_g = colour >> 8 & 0xFF;
        int border_b = colour >> 16 & 0xFF;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int i;
            float size = key.connections[face.ordinal()];
            PipeFaceTex tex = size > 0.0f ? key.sideSprites[face.ordinal()] : key.centerSprite;
            int quadsIndex = size > 0.0f ? 1 : 0;
            MutableQuad[] quadArray = QUADS[quadsIndex][face.ordinal()];
            int startIndex = quads.size();
            for (i = 0; i < tex.getCount(); ++i) {
                PipeBaseModelGenStandard.addQuads(quadArray, quads, PipeBaseModelGenStandard.getSprite(spriteArray, tex, i));
                int c = tex.getColour(i);
                int r = c >> 0 & 0xFF;
                int g = c >> 8 & 0xFF;
                int b = c >> 16 & 0xFF;
                for (int q = startIndex; q < quads.size(); ++q) {
                    ((MutableQuad)quads.get(q)).multColouri(r, g, b, 255);
                }
                startIndex = quads.size();
            }
            if (borderSprite == null) continue;
            PipeBaseModelGenStandard.addQuads(quadArray, quads, borderSprite);
            for (i = startIndex; i < quads.size(); ++i) {
                ((MutableQuad)quads.get(i)).multColouri(border_r, border_g, border_b, 255);
            }
        }
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
        for (MutableQuad q : quads) {
            bakedQuads.add(q.toBakedBlock());
        }
        return bakedQuads;
    }

    @Nullable
    private static TextureAtlasSprite getBorderSprite(PipeModelCacheBase.PipeBaseCutoutKey key) {
        if (key.colour == null) {
            return null;
        }
        if (key.colourType == EnumPipeColourType.BORDER_INNER) {
            return BCTransportSprites.PIPE_COLOUR_BORDER_INNER.getSprite();
        }
        if (key.colourType == EnumPipeColourType.BORDER_OUTER) {
            return BCTransportSprites.PIPE_COLOUR_BORDER_OUTER.getSprite();
        }
        return null;
    }

    private static TextureAtlasSprite getSprite(TextureAtlasSprite[] array, PipeFaceTex tex, int spriteIndex) {
        int index = tex.getTexture(spriteIndex);
        return PipeBaseModelGenStandard.getSprite(array, index);
    }

    private static TextureAtlasSprite getSprite(TextureAtlasSprite[] array, int index) {
        if (array == null || index < 0 || index >= array.length) {
            return Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        return array[index];
    }

    @Override
    public List<BakedQuad> generateTranslucent(PipeModelCacheBase.PipeBaseTranslucentKey key) {
        if (!key.shouldRender()) {
            return ImmutableList.of();
        }
        ArrayList<MutableQuad> quads = new ArrayList<MutableQuad>();
        TextureAtlasSprite sprite = BCTransportSprites.PIPE_COLOUR.getSprite();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            float size = key.connections[face.ordinal()];
            if (size > 0.0f) {
                PipeBaseModelGenStandard.addQuads(QUADS_COLOURED[1][face.ordinal()], quads, sprite);
                continue;
            }
            PipeBaseModelGenStandard.addQuads(QUADS_COLOURED[0][face.ordinal()], quads, sprite);
        }
        int colour = PipeBaseModelGenStandard.getPipeModelColour(key.colour);
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
        for (MutableQuad q : quads) {
            q.colouri(colour);
            bakedQuads.add(q.toBakedBlock());
        }
        return bakedQuads;
    }

    private static int getPipeModelColour(EnumDyeColor c) {
        return 0xFF000000 | ColourUtil.swapArgbToAbgr((int)ColourUtil.getLightHex((EnumDyeColor)c));
    }

    private static void addQuads(MutableQuad[] from, List<MutableQuad> to, TextureAtlasSprite sprite) {
        for (MutableQuad f : from) {
            if (f == null) continue;
            MutableQuad copy = new MutableQuad(f);
            copy.setSprite(sprite);
            copy.texFromSprite(sprite);
            to.add(copy);
        }
    }

    static {
        SPRITES = new IdentityHashMap<PipeDefinition, TextureAtlasSprite[]>();
        QUADS = new MutableQuad[2][][];
        QUADS_COLOURED = new MutableQuad[2][][];
        double colourOffset = 0.01;
        Vec3d[] faceOffset = new Vec3d[6];
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            faceOffset[enumFacing.ordinal()] = new Vec3d(enumFacing.func_176734_d().func_176730_m()).func_186678_a(0.01);
        }
        PipeBaseModelGenStandard.QUADS[0] = new MutableQuad[6][2];
        PipeBaseModelGenStandard.QUADS_COLOURED[0] = new MutableQuad[6][2];
        Point3f center = new Point3f(0.5f, 0.5f, 0.5f);
        Vector3f radius = new Vector3f(0.25f, 0.25f, 0.25f);
        ModelUtil.UvFaceData uvs = new ModelUtil.UvFaceData();
        uvs.minV = 0.25f;
        uvs.minU = 0.25f;
        uvs.maxV = 0.75f;
        uvs.maxU = 0.75f;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            MutableQuad[] colQuads;
            MutableQuad quad = ModelUtil.createFace((EnumFacing)face, (Tuple3f)center, (Tuple3f)radius, (ModelUtil.UvFaceData)uvs);
            quad.setDiffuse(quad.normalvf());
            PipeBaseModelGenStandard.QUADS[0][face.ordinal()][0] = quad;
            PipeBaseModelGenStandard.dupDarker(QUADS[0][face.ordinal()]);
            for (MutableQuad q : colQuads = ModelUtil.createDoubleFace((EnumFacing)face, (Tuple3f)center, (Tuple3f)radius, (ModelUtil.UvFaceData)uvs)) {
                q.translatevd(faceOffset[face.ordinal()]);
            }
            PipeBaseModelGenStandard.QUADS_COLOURED[0][face.ordinal()] = colQuads;
        }
        int[][] nArrayArray = new int[][]{{2, 0, 3, 3}, {0, 2, 1, 1}, {2, 0, 0, 2}, {0, 2, 2, 0}, {3, 3, 0, 2}, {1, 1, 2, 0}};
        ModelUtil.UvFaceData[] types = new ModelUtil.UvFaceData[]{ModelUtil.UvFaceData.from16((int)4, (int)0, (int)12, (int)4), ModelUtil.UvFaceData.from16((int)4, (int)12, (int)12, (int)16), ModelUtil.UvFaceData.from16((int)0, (int)4, (int)4, (int)12), ModelUtil.UvFaceData.from16((int)12, (int)4, (int)16, (int)12)};
        PipeBaseModelGenStandard.QUADS[1] = new MutableQuad[6][8];
        PipeBaseModelGenStandard.QUADS_COLOURED[1] = new MutableQuad[6][8];
        for (EnumFacing side : EnumFacing.field_82609_l) {
            center = new Point3f((float)side.func_82601_c() * 0.375f, (float)side.func_96559_d() * 0.375f, (float)side.func_82599_e() * 0.375f);
            radius = new Vector3f(side.func_176740_k() == EnumFacing.Axis.X ? 0.125f : 0.25f, side.func_176740_k() == EnumFacing.Axis.Y ? 0.125f : 0.25f, side.func_176740_k() == EnumFacing.Axis.Z ? 0.125f : 0.25f);
            center.add((Tuple3f)new Point3f(0.5f, 0.5f, 0.5f));
            int i = 0;
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (face.func_176740_k() == side.func_176740_k()) continue;
                MutableQuad quad = ModelUtil.createFace((EnumFacing)face, (Tuple3f)center, (Tuple3f)radius, (ModelUtil.UvFaceData)types[i]);
                quad.rotateTextureUp(nArrayArray[side.ordinal()][i]);
                MutableQuad col = new MutableQuad(quad);
                quad.setDiffuse(quad.normalvf());
                PipeBaseModelGenStandard.QUADS[1][side.ordinal()][i] = quad;
                col.translatevd(faceOffset[face.ordinal()]);
                PipeBaseModelGenStandard.QUADS_COLOURED[1][side.ordinal()][i++] = col;
            }
            PipeBaseModelGenStandard.dupDarker(QUADS[1][side.ordinal()]);
            PipeBaseModelGenStandard.dupInverted(QUADS_COLOURED[1][side.ordinal()]);
        }
    }
}

