/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventItem;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.transport.pipe.behaviour.PipeBehaviourDiamond;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class PipeBehaviourDiamondItem
extends PipeBehaviourDiamond {
    public PipeBehaviourDiamondItem(IPipe pipe) {
        super(pipe);
    }

    public PipeBehaviourDiamondItem(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
    }

    @PipeEventHandler
    public void sideCheck(PipeEventItem.SideCheck sideCheck) {
        ItemStack toCompare = sideCheck.stack;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!sideCheck.isAllowed(face) || !this.pipe.isConnected(face)) continue;
            int offset = 9 * face.ordinal();
            boolean sideAllowed = false;
            boolean foundItem = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack compareTo = this.filters.getStackInSlot(offset + i);
                if (compareTo.func_190926_b()) continue;
                foundItem = true;
                if (!StackUtil.isMatchingItemOrList((ItemStack)compareTo, (ItemStack)toCompare)) continue;
                sideAllowed = true;
                break;
            }
            if (!foundItem) continue;
            if (sideAllowed) {
                sideCheck.increasePriority(face, 12);
                continue;
            }
            sideCheck.disallow(new EnumFacing[]{face});
        }
    }

    @PipeEventHandler
    public void split(PipeEventItem.Split split) {
        EnumFacing[] allSides = split.getAllPossibleDestinations().toArray(new EnumFacing[0]);
        if (allSides.length == 0 || allSides.length == 1) {
            return;
        }
        PipeEventItem.ItemEntry[] items = split.items.toArray(new PipeEventItem.ItemEntry[0]);
        split.items.clear();
        for (PipeEventItem.ItemEntry item : items) {
            int s;
            int i;
            int[] countPerSide = new int[allSides.length];
            int totalCount = 0;
            for (int s2 = 0; s2 < allSides.length; ++s2) {
                int offset = 9 * allSides[s2].ordinal();
                for (i = 0; i < 9; ++i) {
                    ItemStack compareTo = this.filters.getStackInSlot(offset + i);
                    if (compareTo.func_190926_b() || !StackUtil.isMatchingItemOrList((ItemStack)compareTo, (ItemStack)item.stack)) continue;
                    int count = compareTo.func_190916_E();
                    totalCount += count;
                    int n = s2;
                    countPerSide[n] = countPerSide[n] + count;
                }
            }
            if (totalCount == 0) {
                totalCount = allSides.length;
                Arrays.fill(countPerSide, 1);
            } else {
                int hcf = countPerSide[0];
                int[] offset = countPerSide;
                i = offset.length;
                for (int compareTo = 0; compareTo < i; ++compareTo) {
                    int c = offset[compareTo];
                    hcf = MathUtil.findHighestCommonFactor((int)hcf, (int)c);
                }
                if (hcf != 1) {
                    totalCount /= hcf;
                    int i2 = 0;
                    while (i2 < countPerSide.length) {
                        int n = i2++;
                        countPerSide[n] = countPerSide[n] / hcf;
                    }
                }
            }
            PipeEventItem.ItemEntry[] entries = new PipeEventItem.ItemEntry[allSides.length];
            ItemStack toSplit = item.stack;
            if (toSplit.func_190916_E() >= totalCount) {
                int leftOver = toSplit.func_190916_E() % totalCount;
                int multiples = (toSplit.func_190916_E() - leftOver) / totalCount;
                for (s = 0; s < allSides.length; ++s) {
                    ItemStack toSide = toSplit.func_77946_l();
                    toSide.func_190920_e(countPerSide[s] * multiples);
                    entries[s] = new PipeEventItem.ItemEntry(item.colour, toSide, item.from);
                    ArrayList<EnumFacing> dests = new ArrayList<EnumFacing>(1);
                    dests.add(allSides[s]);
                    entries[s].to = dests;
                }
                toSplit.func_190920_e(leftOver);
            }
            if (!toSplit.func_190926_b()) {
                int[] randLookup = new int[totalCount];
                int j = 0;
                for (s = 0; s < allSides.length; ++s) {
                    int len = countPerSide[s];
                    Arrays.fill(randLookup, j, j + len, s);
                    j += len;
                }
                while (!toSplit.func_190926_b()) {
                    int rand = split.holder.getPipeWorld().field_73012_v.nextInt(totalCount);
                    int face = randLookup[rand];
                    if (entries[face] == null) {
                        ItemStack stack = toSplit.func_77946_l();
                        stack.func_190920_e(1);
                        PipeEventItem.ItemEntry entry = new PipeEventItem.ItemEntry(item.colour, stack, item.from);
                        ArrayList<EnumFacing> dests = entry.to = new ArrayList<EnumFacing>(1);
                        dests.add(allSides[face]);
                        entries[face] = entry;
                    } else {
                        entries[face].stack.func_190917_f(1);
                    }
                    toSplit.func_190918_g(1);
                }
            }
            for (int s3 = 0; s3 < allSides.length; ++s3) {
                PipeEventItem.ItemEntry entry = entries[s3];
                if (entry == null) continue;
                split.items.add(entry);
            }
        }
    }
}

