/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.flow;

import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.misc.VecUtil;
import buildcraft.transport.pipe.flow.PipeFlowItems;
import java.util.EnumSet;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class TravellingItem {
    @Nonnull
    public final Supplier<ItemStack> clientItemLink;
    public int stackSize;
    public EnumDyeColor colour;
    @Nonnull
    ItemStack stack;
    int id = 0;
    boolean toCenter;
    double speed = 0.05;
    long tickStarted;
    long tickFinished;
    int timeToDest;
    EnumFacing side;
    EnumSet<EnumFacing> tried = EnumSet.noneOf(EnumFacing.class);
    boolean isPhantom = false;

    public TravellingItem(@Nonnull ItemStack stack) {
        this.stack = stack;
        this.clientItemLink = () -> ItemStack.field_190927_a;
    }

    public TravellingItem(Supplier<ItemStack> clientStackLink, int count) {
        this.clientItemLink = (Supplier)StackUtil.asNonNull(clientStackLink);
        this.stackSize = count;
        this.stack = StackUtil.EMPTY;
    }

    public TravellingItem(NBTTagCompound nbt, long tickNow) {
        this.clientItemLink = () -> ItemStack.field_190927_a;
        this.stack = new ItemStack(nbt.func_74775_l("stack"));
        byte c = nbt.func_74771_c("colour");
        this.colour = c == 0 ? null : EnumDyeColor.func_176764_b((int)(c - 1));
        this.toCenter = nbt.func_74767_n("toCenter");
        this.speed = nbt.func_74769_h("speed");
        if (this.speed < 0.001) {
            this.speed = 0.001;
        }
        this.tickStarted = (long)nbt.func_74762_e("tickStarted") + tickNow;
        this.tickFinished = (long)nbt.func_74762_e("tickFinished") + tickNow;
        this.timeToDest = nbt.func_74762_e("timeToDest");
        this.side = (EnumFacing)NBTUtilBC.readEnum((NBTBase)nbt.func_74781_a("side"), EnumFacing.class);
        if (this.side == null || this.timeToDest == 0) {
            this.toCenter = true;
        }
        this.tried = NBTUtilBC.readEnumSet((NBTBase)nbt.func_74781_a("tried"), EnumFacing.class);
        this.isPhantom = nbt.func_74767_n("isPhantom");
    }

    public NBTTagCompound writeToNbt(long tickNow) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("stack", (NBTBase)this.stack.serializeNBT());
        nbt.func_74774_a("colour", (byte)(this.colour == null ? 0 : this.colour.func_176765_a() + 1));
        nbt.func_74757_a("toCenter", this.toCenter);
        nbt.func_74780_a("speed", this.speed);
        nbt.func_74768_a("tickStarted", (int)(this.tickStarted - tickNow));
        nbt.func_74768_a("tickFinished", (int)(this.tickFinished - tickNow));
        nbt.func_74768_a("timeToDest", this.timeToDest);
        nbt.func_74782_a("side", NBTUtilBC.writeEnum((Enum)this.side));
        nbt.func_74782_a("tried", NBTUtilBC.writeEnumSet(this.tried, EnumFacing.class));
        if (this.isPhantom) {
            nbt.func_74757_a("isPhantom", true);
        }
        return nbt;
    }

    public int getCurrentDelay(long tickNow) {
        long diff = this.tickFinished - tickNow;
        if (diff < 0L) {
            return 0;
        }
        return (int)diff;
    }

    public double getWayThrough(long now) {
        long diff = this.tickFinished - this.tickStarted;
        long nowDiff = now - this.tickStarted;
        return (double)nowDiff / (double)diff;
    }

    public void genTimings(long now, double distance) {
        this.tickStarted = now;
        this.timeToDest = (int)Math.ceil(distance / this.speed);
        this.tickFinished = now + (long)this.timeToDest;
    }

    public boolean canMerge(TravellingItem with) {
        if (this.isPhantom || with.isPhantom) {
            return false;
        }
        return this.toCenter == with.toCenter && this.colour == with.colour && this.side == with.side && Math.abs(this.tickFinished - with.tickFinished) < 4L && this.stack.func_77976_d() >= this.stack.func_190916_E() + with.stack.func_190916_E() && StackUtil.canMerge((ItemStack)this.stack, (ItemStack)with.stack);
    }

    public boolean mergeWith(TravellingItem with) {
        if (this.canMerge(with)) {
            this.stack.func_190917_f(with.stack.func_190916_E());
            return true;
        }
        return false;
    }

    public Vec3d interpolatePosition(Vec3d start, Vec3d end, long tick, float partialTicks) {
        long diff = this.tickFinished - this.tickStarted;
        long nowDiff = tick - this.tickStarted;
        double sinceStart = (float)nowDiff + partialTicks;
        double interpMul = sinceStart / (double)diff;
        double oneMinus = 1.0 - interpMul;
        if (interpMul <= 0.0) {
            return start;
        }
        if (interpMul >= 1.0) {
            return end;
        }
        double x = oneMinus * start.field_72450_a + interpMul * end.field_72450_a;
        double y = oneMinus * start.field_72448_b + interpMul * end.field_72448_b;
        double z = oneMinus * start.field_72449_c + interpMul * end.field_72449_c;
        return new Vec3d(x, y, z);
    }

    public Vec3d getRenderPosition(BlockPos pos, long tick, float partialTicks, PipeFlowItems flow) {
        Vec3d vecTo;
        Vec3d vecFrom;
        Vec3d vecSide;
        long diff = this.tickFinished - this.tickStarted;
        long afterTick = tick - this.tickStarted;
        float interp = ((float)afterTick + partialTicks) / (float)diff;
        interp = Math.max(0.0f, Math.min(1.0f, interp));
        Vec3d center = new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5);
        Vec3d vec3d = vecSide = this.side == null ? center : VecUtil.offset((Vec3d)center, (EnumFacing)this.side, (double)flow.getPipeLength(this.side));
        if (this.toCenter) {
            vecFrom = vecSide;
            vecTo = center;
        } else {
            vecFrom = center;
            vecTo = vecSide;
        }
        return VecUtil.scale((Vec3d)vecFrom, (double)(1.0f - interp)).func_178787_e(VecUtil.scale((Vec3d)vecTo, (double)interp));
    }

    public EnumFacing getRenderDirection(long tick, float partialTicks) {
        long diff = this.tickFinished - this.tickStarted;
        long afterTick = tick - this.tickStarted;
        float interp = ((float)afterTick + partialTicks) / (float)diff;
        interp = Math.max(0.0f, Math.min(1.0f, interp));
        if (this.toCenter) {
            return this.side == null ? null : this.side.func_176734_d();
        }
        return this.side;
    }

    public boolean isVisible() {
        return true;
    }
}

