/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.statements.TriggerPipeSignal;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TriggerParameterSignal
implements IStatementParameter {
    public static final TriggerParameterSignal EMPTY = new TriggerParameterSignal(false, null);
    private static final Map<EnumDyeColor, TriggerParameterSignal> SIGNALS_OFF = new EnumMap<EnumDyeColor, TriggerParameterSignal>(EnumDyeColor.class);
    private static final Map<EnumDyeColor, TriggerParameterSignal> SIGNALS_ON = new EnumMap<EnumDyeColor, TriggerParameterSignal>(EnumDyeColor.class);
    public final boolean active;
    @Nullable
    public final EnumDyeColor colour;

    public static TriggerParameterSignal get(boolean active, EnumDyeColor colour) {
        if (colour == null) {
            return EMPTY;
        }
        return new TriggerParameterSignal(active, colour);
    }

    public static TriggerParameterSignal readFromNbt(NBTTagCompound nbt) {
        if (nbt.func_150297_b("color", 99)) {
            EnumDyeColor colour = EnumDyeColor.func_176764_b((int)nbt.func_74771_c("color"));
            boolean active = nbt.func_74767_n("active");
            return TriggerParameterSignal.get(active, colour);
        }
        return EMPTY;
    }

    public void writeToNbt(NBTTagCompound nbt) {
        if (this.colour != null) {
            nbt.func_74774_a("color", (byte)this.colour.func_176765_a());
            nbt.func_74757_a("active", this.active);
        }
    }

    public static TriggerParameterSignal readFromBuf(PacketBuffer buffer) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc((ByteBuf)buffer);
        EnumDyeColor colour = (EnumDyeColor)MessageUtil.readEnumOrNull((ByteBuf)buf, EnumDyeColor.class);
        if (colour == null) {
            return EMPTY;
        }
        return TriggerParameterSignal.get(buf.readBoolean(), colour);
    }

    public void writeToBuf(PacketBuffer buffer) {
        MessageUtil.writeEnumOrNull((ByteBuf)buffer, (Enum)this.colour);
        if (this.colour != null) {
            buffer.writeBoolean(this.active);
        }
    }

    private TriggerParameterSignal(boolean active, EnumDyeColor colour) {
        this.active = active;
        this.colour = colour;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    @SideOnly(value=Side.CLIENT)
    public ISprite getSprite() {
        if (this.colour == null) {
            return null;
        }
        return BCTransportSprites.getPipeSignal(this.active, this.colour);
    }

    public TriggerParameterSignal onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        return null;
    }

    public String getDescription() {
        if (this.colour == null) {
            return null;
        }
        return String.format(LocaleUtil.localize((String)("gate.trigger.pipe.wire." + (this.active ? "active" : "inactive"))), ColourUtil.getTextFullTooltip((EnumDyeColor)this.colour));
    }

    public String getUniqueTag() {
        return "buildcraft:pipeWireTrigger";
    }

    public IStatementParameter rotateLeft() {
        return this;
    }

    public TriggerParameterSignal[] getPossible(IStatementContainer source) {
        if (!(source instanceof IGate)) {
            return null;
        }
        IGate gate = (IGate)source;
        ArrayList<TriggerParameterSignal> poss = new ArrayList<TriggerParameterSignal>(ColourUtil.COLOURS.length * 2 + 1);
        poss.add(EMPTY);
        for (EnumDyeColor c : ColourUtil.COLOURS) {
            if (!TriggerPipeSignal.doesGateHaveColour(gate, c)) continue;
            poss.add(TriggerParameterSignal.get(true, c));
            poss.add(TriggerParameterSignal.get(false, c));
        }
        return poss.toArray(new TriggerParameterSignal[poss.size()]);
    }

    static {
        for (EnumDyeColor colour : ColourUtil.COLOURS) {
            SIGNALS_OFF.put(colour, new TriggerParameterSignal(false, colour));
            SIGNALS_ON.put(colour, new TriggerParameterSignal(true, colour));
        }
    }
}

