/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.transport.IWireManager;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.BCTransportStatements;
import buildcraft.transport.statements.TriggerParameterSignal;
import java.util.Locale;
import net.minecraft.item.EnumDyeColor;

public class TriggerPipeSignal
extends BCStatement
implements ITriggerInternal {
    private final boolean active;
    private final EnumDyeColor colour;

    public TriggerPipeSignal(boolean active, EnumDyeColor colour) {
        super(new String[]{"buildcraft:pipe.wire.input." + colour.func_176610_l().toLowerCase(Locale.ROOT) + (active ? ".active" : ".inactive"), "buildcraft.pipe.wire.input." + colour.func_176610_l().toLowerCase(Locale.ROOT) + (active ? ".active" : ".inactive")});
        this.active = active;
        this.colour = colour;
    }

    public static boolean doesGateHaveColour(IGate gate, EnumDyeColor c) {
        return gate.getPipeHolder().getWireManager().hasPartOfColor(c);
    }

    public int maxParameters() {
        return 3;
    }

    public String getDescription() {
        return String.format(LocaleUtil.localize((String)("gate.trigger.pipe.wire." + (this.active ? "active" : "inactive"))), ColourUtil.getTextFullTooltip((EnumDyeColor)this.colour));
    }

    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        if (!(container instanceof IGate)) {
            return false;
        }
        IGate gate = (IGate)container;
        IWireManager wires = gate.getPipeHolder().getWireManager();
        if (this.active ? !wires.isAnyPowered(this.colour) : wires.isAnyPowered(this.colour)) {
            return false;
        }
        for (IStatementParameter param : parameters) {
            if (param == null || !(param instanceof TriggerParameterSignal)) continue;
            TriggerParameterSignal signal = (TriggerParameterSignal)param;
            if (signal.colour == null || !(signal.active ? !wires.isAnyPowered(signal.colour) : wires.isAnyPowered(signal.colour))) continue;
            return false;
        }
        return true;
    }

    public IStatementParameter createParameter(int index) {
        return TriggerParameterSignal.EMPTY;
    }

    public SpriteHolderRegistry.SpriteHolder getSprite() {
        return BCTransportSprites.getPipeSignal(this.active, this.colour);
    }

    public IStatement[] getPossible() {
        return BCTransportStatements.TRIGGER_PIPE_SIGNAL;
    }
}

