/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.enchantlibrary.shelf;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.BlockBaseFacing;
import com.lothrazar.cyclicmagic.block.core.IBlockHasTESR;
import com.lothrazar.cyclicmagic.block.enchantlibrary.ctrl.BlockLibraryController;
import com.lothrazar.cyclicmagic.block.enchantlibrary.ctrl.TileEntityLibraryCtrl;
import com.lothrazar.cyclicmagic.block.enchantlibrary.shelf.ItemBlockLibrary;
import com.lothrazar.cyclicmagic.block.enchantlibrary.shelf.LibraryTESR;
import com.lothrazar.cyclicmagic.block.enchantlibrary.shelf.TileEntityLibrary;
import com.lothrazar.cyclicmagic.data.EnchantStack;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.data.QuadrantEnum;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLibrary
extends BlockBaseFacing
implements IBlockHasTESR,
IHasRecipe,
IContent {
    private boolean enabled;

    public BlockLibrary() {
        super(Material.field_151575_d);
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)this, new ItemBlockLibrary(this), this.getContentName(), GuideCategory.BLOCK);
        BlockRegistry.registerTileEntity(TileEntityLibrary.class, "cyclicmagiclibrary_te");
        BlockRegistry.registerTileEntity(TileEntityLibraryCtrl.class, "cyclicmagiclibrary_ctrl_te");
        BlockLibraryController lc = new BlockLibraryController();
        BlockRegistry.registerBlock((Block)lc, "block_library_ctrl", GuideCategory.BLOCK);
        ModCyclic.instance.events.register(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public String getContentName() {
        return "block_library";
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.content";
        this.enabled = config.getBoolean(this.getContentName(), category, true, " Set false to delete - requires restart");
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityLibrary();
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)enumfacing.func_176734_d());
    }

    @Override
    public EnumFacing getFacingFromState(IBlockState state) {
        return super.getFacingFromState(state).func_176734_d();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!(world.func_175625_s(pos) instanceof TileEntityLibrary)) {
            return false;
        }
        TileEntityLibrary library = (TileEntityLibrary)world.func_175625_s(pos);
        if (side != this.getFacingFromState(state)) {
            return false;
        }
        QuadrantEnum segment = QuadrantEnum.getForFace(side, hitX, hitY, hitZ);
        if (segment == null) {
            return false;
        }
        library.setLastClicked(segment);
        ItemStack playerHeld = player.func_184586_b(hand);
        if (playerHeld.func_77973_b().equals(Items.field_151134_bR)) {
            if (playerHeld.func_190916_E() != 1) {
                if (world.field_72995_K) {
                    UtilChat.addChatMessage(player, this.getRawName() + ".stacksize");
                }
                return false;
            }
            ItemStack theThing = library.addEnchantmentToQuadrant(playerHeld, segment);
            player.func_184611_a(hand, ItemStack.field_190927_a);
            if (!theThing.func_190926_b()) {
                player.func_191521_c(theThing);
            } else {
                player.func_191521_c(new ItemStack(Items.field_151122_aG));
            }
            this.onSuccess(player);
            library.func_70296_d();
            return true;
        }
        if (playerHeld.func_77973_b().equals(Items.field_151122_aG) && !player.func_184811_cZ().func_185141_a(Items.field_151122_aG)) {
            EnchantStack es = library.getEnchantStack(segment);
            if (!es.isEmpty()) {
                UtilChat.sendStatusMessage(player, UtilChat.lang(es.getEnch().func_77320_a()) + " " + es.levelName());
                this.dropEnchantedBookOnPlayer(es, player, pos);
                playerHeld.func_190918_g(1);
                library.removeEnchantment(segment);
                this.onSuccess(player);
                library.func_70296_d();
                return true;
            }
        } else if (!(player.func_70093_af() || player.field_70170_p.field_72995_K || playerHeld.func_190926_b())) {
            EnchantStack es = library.getEnchantStack(segment);
            UtilChat.sendStatusMessage(player, es.toString());
            library.func_70296_d();
            return true;
        }
        return false;
    }

    private void onSuccess(EntityPlayer player) {
        UtilSound.playSound(player, SoundEvents.field_190021_aL);
    }

    private void dropEnchantedBookOnPlayer(EnchantStack ench, EntityPlayer player, BlockPos pos) {
        ItemStack stack = ench.makeEnchantedBook();
        if (!player.func_191521_c(stack)) {
            player.func_71019_a(stack, true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLibrary.class, new LibraryTESR(this));
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 4), " r ", "sgs", " r ", Character.valueOf('g'), Blocks.field_150342_X, Character.valueOf('s'), Blocks.field_185767_cT, Character.valueOf('r'), "obsidian");
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityLibrary lib;
        NBTTagCompound newtag;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = Item.func_150898_a((Block)this);
        TileEntity ent = world.func_175625_s(pos);
        ItemStack stack = new ItemStack(item);
        if (ent instanceof TileEntityLibrary && (newtag = (lib = (TileEntityLibrary)ent).writeToNBTenchants(new NBTTagCompound(), true)) != null) {
            stack.func_77982_d(newtag);
        }
        ret.add(stack);
        return ret;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77978_p() != null && world.func_175625_s(pos) instanceof TileEntityLibrary) {
            NBTTagCompound tags = stack.func_77978_p();
            TileEntityLibrary container = (TileEntityLibrary)world.func_175625_s(pos);
            container.readFromNBTenchants(tags);
        }
    }
}

