/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.exppylon;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.block.core.BlockBaseFacingInventory;
import com.lothrazar.cyclicmagic.block.core.IBlockHasTESR;
import com.lothrazar.cyclicmagic.block.exppylon.ItemBlockPylon;
import com.lothrazar.cyclicmagic.block.exppylon.TileEntityXpPylon;
import com.lothrazar.cyclicmagic.block.exppylon.XpPylonTESR;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.FluidsRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockXpPylon
extends BlockBaseFacingInventory
implements IHasRecipe,
IBlockHasTESR,
IContent {
    private boolean enabled;

    public BlockXpPylon() {
        super(Material.field_151576_e, 19);
        this.func_149711_c(3.0f).func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.setTranslucent();
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityXpPylon();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityXpPylon.class, (TileEntitySpecialRenderer)new XpPylonTESR(0, 1));
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @Override
    public String getContentName() {
        return "exp_pylon";
    }

    @Override
    public void register() {
        FluidsRegistry.registerExp();
        BlockRegistry.registerBlock((Block)this, new ItemBlockPylon(this), this.getContentName(), GuideCategory.BLOCKMACHINE);
        BlockRegistry.registerTileEntity(TileEntityXpPylon.class, this.getContentName() + "_te");
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("ExperiencePylon", "cyclicmagic.content", true, this.getContentName() + " Set false to delete - requires restart");
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this), "vhv", "grg", "sis", Character.valueOf('v'), "vine", Character.valueOf('h'), Blocks.field_150438_bZ, Character.valueOf('i'), "ingotGold", Character.valueOf('g'), "dyeLime", Character.valueOf('r'), Items.field_151059_bz, Character.valueOf('s'), "ingotBrickNether");
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityXpPylon te = (TileEntityXpPylon)world.func_175625_s(pos);
        boolean success = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
        if (te != null && !world.field_72995_K) {
            int currentFluid = te.getCurrentFluidStackAmount();
            UtilChat.sendStatusMessage(player, UtilChat.lang("cyclic.fluid.amount") + currentFluid);
        }
        return success || FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) != null || super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityXpPylon te;
        FluidStack fs;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = Item.func_150898_a((Block)this);
        TileEntity ent = world.func_175625_s(pos);
        ItemStack stack = new ItemStack(item);
        if (ent != null && ent instanceof TileEntityXpPylon && (fs = (te = (TileEntityXpPylon)ent).getCurrentFluidStack()) != null) {
            UtilNBT.setItemStackNBTVal(stack, "Amount", fs.amount);
            String resourceStr = FluidRegistry.getFluidName((Fluid)fs.getFluid());
            UtilNBT.setItemStackNBTVal(stack, "FluidName", resourceStr);
        }
        ret.add(stack);
        return ret;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            NBTTagCompound tags = stack.func_77978_p();
            int fluidAmt = tags.func_74762_e("Amount");
            String resourceStr = tags.func_74779_i("FluidName");
            TileEntityXpPylon container = (TileEntityXpPylon)worldIn.func_175625_s(pos);
            Fluid fluidObj = FluidRegistry.getFluid((String)resourceStr);
            if (fluidObj != null) {
                container.fill(new FluidStack(fluidObj, fluidAmt), true);
            }
        }
    }
}

