/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.laser;

import com.lothrazar.cyclicmagic.block.laser.TileEntityLaser;
import com.lothrazar.cyclicmagic.data.BlockPosDim;
import com.lothrazar.cyclicmagic.util.RenderUtil;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LaserAnimatedTESR
extends TileEntitySpecialRenderer<TileEntityLaser> {
    public void render(TileEntityLaser te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!te.isRunning()) {
            return;
        }
        float[] color = te.getColor();
        double rotationTime = te.isPulsing() ? 120.0 : 0.0;
        double beamWidth = 0.09;
        BlockPos first = te.func_174877_v();
        BlockPosDim second = null;
        int timer = 100;
        if (te.isExtending()) {
            timer = te.func_174887_a_(TileEntityLaser.Fields.TIMER.ordinal());
        }
        for (int i = 0; i < te.func_70302_i_(); ++i) {
            second = te.getTarget(i);
            if (second == null || second.toBlockPos() == null || second.getDimension() != te.getDimension()) continue;
            RenderUtil.LaserConfig laserCnf = new RenderUtil.LaserConfig(first, second.toBlockPos(), rotationTime, te.alphaCalculated(), beamWidth, color);
            laserCnf.xOffset = te.getxOffset();
            laserCnf.yOffset = te.getyOffset();
            laserCnf.zOffset = te.getzOffset();
            laserCnf.timer = timer;
            RenderUtil.renderLaser(laserCnf);
        }
    }

    public boolean isGlobalRenderer(TileEntityLaser te) {
        return true;
    }
}

