/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.cannon;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.capability.EnergyCapabilityItemStack;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.cannon.EntityGolemLaser;
import com.lothrazar.cyclicmagic.item.core.BaseItem;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemProjectileCannon
extends BaseItem
implements IHasRecipe,
IContent {
    private static final int ENERGY_MAX = 32000;
    public static final int ENERGY_COST = 100;
    private boolean enabled;

    public ItemProjectileCannon() {
        this.func_77625_d(1);
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName(), GuideCategory.ITEMTHROW);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("cyclicmagic", "firecannon"), EntityGolemLaser.class, (String)"firecannon", (int)1031, (Object)ModCyclic.instance, (int)64, (int)1, (boolean)true);
    }

    @Override
    public String getContentName() {
        return "laser_cannon";
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean(this.getContentName(), "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    public void createBullet(World world, EntityPlayer player) {
        EntityGolemLaser bullet = new EntityGolemLaser(world);
        int colorIndex = MathHelper.func_76136_a((Random)world.field_73012_v, (int)0, (int)(EntityGolemLaser.VariantColors.values().length - 1));
        bullet.func_184212_Q().func_187227_b(EntityGolemLaser.variant, (Object)colorIndex);
        float speed = 4.0f;
        bullet.initCustom(player.field_70165_t, player.field_70163_u + 1.52, player.field_70161_v, player.func_70040_Z().field_72450_a * 0.5, player.func_70040_Z().field_72448_b * 0.5, player.func_70040_Z().field_72449_c * 0.5, speed, player.func_110124_au());
        world.func_72838_d((Entity)bullet);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedOreRecipe(new ItemStack((Item)this), " ct", "bbc", "qb ", Character.valueOf('t'), Items.field_190930_cZ, Character.valueOf('c'), Items.field_151059_bz, Character.valueOf('b'), new ItemStack(Items.field_151045_i), Character.valueOf('q'), new ItemStack(Blocks.field_180397_cI, 1, BlockPrismarine.field_176334_N));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        IEnergyStorage storage = (IEnergyStorage)player.func_184586_b(hand).getCapability(CapabilityEnergy.ENERGY, null);
        if (storage.getEnergyStored() < 100 && 100 > storage.extractEnergy(100, true)) {
            UtilChat.sendStatusMessage(player, "cyclic.item.empty");
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        this.createBullet(world, player);
        UtilSound.playSound(player, player.func_180425_c(), SoundRegistry.fireball_staff_launch, SoundCategory.PLAYERS, 0.1f);
        player.func_184609_a(hand);
        storage.extractEnergy(100, false);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xBC000C;
    }

    public double getDurabilityForDisplay(ItemStack item) {
        IEnergyStorage storage = (IEnergyStorage)item.getCapability(CapabilityEnergy.ENERGY, null);
        double energy = storage.getEnergyStored();
        return 1.0 - energy / (double)storage.getMaxEnergyStored();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, World player, List<String> tooltip, ITooltipFlag advanced) {
        IEnergyStorage storage = (IEnergyStorage)item.getCapability(CapabilityEnergy.ENERGY, null);
        tooltip.add(storage.getEnergyStored() + "/" + storage.getMaxEnergyStored());
        super.func_77624_a(item, player, tooltip, advanced);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyCapabilityItemStack(stack, 32000);
    }
}

