/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.util;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import gr8pefish.ironbackpacks.IronBackpacks;
import gr8pefish.ironbackpacks.api.IronBackpacksAPI;
import gr8pefish.ironbackpacks.api.blacklist.IInventoryBlacklist;
import gr8pefish.ironbackpacks.util.JsonUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class InventoryBlacklist
implements IInventoryBlacklist {
    public static final InventoryBlacklist INSTANCE = new InventoryBlacklist();
    private final Set<ItemPair> itemBlacklist = Sets.newHashSet();
    private final Set<String> nbtBlacklist = Sets.newHashSet();

    private InventoryBlacklist() {
    }

    @Override
    public void blacklist(@Nonnull ItemStack stack) {
        ItemPair pair = new ItemPair(stack.func_77973_b(), stack.func_77952_i());
        if (!this.itemBlacklist.contains(pair)) {
            this.itemBlacklist.add(pair);
        }
    }

    @Override
    public void blacklist(@Nonnull String tagKey) {
        if (!this.nbtBlacklist.contains(tagKey)) {
            this.nbtBlacklist.add(tagKey);
        }
    }

    @Override
    public boolean isBlacklisted(@Nonnull ItemStack stack) {
        for (ItemPair pair : this.itemBlacklist) {
            if (pair.getItem() != stack.func_77973_b() || pair.getMeta() != stack.func_77952_i() && pair.getMeta() != Short.MAX_VALUE) continue;
            return true;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || tag.func_82582_d()) {
            return false;
        }
        for (String key : this.nbtBlacklist) {
            String[] subTags;
            if (tag.func_74764_b(key)) {
                return true;
            }
            for (String subTag : subTags = key.split("\\.")) {
                if (tag.func_82582_d() || tag.func_150299_b(subTag) != 10) {
                    return tag.func_74764_b(subTag);
                }
                tag = tag.func_74775_l(subTag);
            }
        }
        return false;
    }

    public static void initBlacklist() {
        File jsonConfig = new File(Loader.instance().getConfigDir(), "ironbackpacks" + File.separator + "blacklist.json");
        InventoryBlacklist blacklist = JsonUtil.fromJson(TypeToken.get(InventoryBlacklist.class), jsonConfig, new InventoryBlacklist());
        InventoryBlacklist.INSTANCE.itemBlacklist.addAll(blacklist.itemBlacklist);
        InventoryBlacklist.INSTANCE.nbtBlacklist.addAll(blacklist.nbtBlacklist);
        try {
            Field inventoryBlacklist = IronBackpacksAPI.class.getDeclaredField("INVENTORY_BLACKLIST");
            EnumHelper.setFailsafeFieldValue((Field)inventoryBlacklist, null, (Object)INSTANCE);
        }
        catch (Exception e) {
            IronBackpacks.LOGGER.error("Error setting blacklist instance for API usage.");
        }
    }

    public static class ItemPair {
        @JsonAdapter(value=Serializer.class)
        private final Item item;
        private final int meta;

        public ItemPair(Item item, int meta) {
            this.item = item;
            this.meta = meta;
        }

        public Item getItem() {
            return this.item;
        }

        public int getMeta() {
            return this.meta;
        }

        public static class Serializer
        implements JsonSerializer<Item>,
        JsonDeserializer<Item> {
            public Item deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.getAsString()));
            }

            public JsonElement serialize(Item src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.getRegistryName().toString());
            }
        }
    }
}

