/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RockCrystalHandler {
    private static final ResourceLocation CAP_ROCKCRYSTAL_NAME = new ResourceLocation("astralsorcery", "cap_chunk_rock_crystal_position");
    public static RockCrystalHandler INSTANCE = new RockCrystalHandler();
    @CapabilityInject(value=RockCrystalPositions.class)
    private static Capability<RockCrystalPositions> CAPABILITY_CHUNK_ROCK_CRYSTALS = null;

    public List<BlockPos> collectPositions(World world, ChunkPos center, int chunkRadius) {
        LinkedList<BlockPos> out = new LinkedList<BlockPos>();
        for (int xx = -chunkRadius; xx <= chunkRadius; ++xx) {
            for (int zz = -chunkRadius; zz <= chunkRadius; ++zz) {
                Chunk ch;
                RockCrystalPositions positions;
                ChunkPos other = new ChunkPos(center.field_77276_a + xx, center.field_77275_b + zz);
                if (!MiscUtils.isChunkLoaded(world, other) || (positions = (RockCrystalPositions)(ch = world.func_72964_e(other.field_77276_a, other.field_77275_b)).getCapability(CAPABILITY_CHUNK_ROCK_CRYSTALS, null)) == null) continue;
                out.addAll(positions.crystalPositions);
            }
        }
        return out;
    }

    public boolean addOre(World world, BlockPos pos, boolean force) {
        ChunkPos ch = new ChunkPos(pos);
        if (force || MiscUtils.isChunkLoaded(world, ch)) {
            return this.addOre(world.func_72964_e(ch.field_77276_a, ch.field_77275_b), pos);
        }
        return false;
    }

    public boolean addOre(Chunk chunk, BlockPos pos) {
        RockCrystalPositions positions = (RockCrystalPositions)chunk.getCapability(CAPABILITY_CHUNK_ROCK_CRYSTALS, null);
        if (positions != null) {
            if (positions.crystalPositions.add(pos)) {
                chunk.func_76630_e();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeOre(World world, BlockPos pos, boolean force) {
        ChunkPos ch = new ChunkPos(pos);
        if (force || MiscUtils.isChunkLoaded(world, ch)) {
            return this.removeOre(world.func_72964_e(ch.field_77276_a, ch.field_77275_b), pos);
        }
        return false;
    }

    public boolean removeOre(Chunk chunk, BlockPos pos) {
        RockCrystalPositions positions = (RockCrystalPositions)chunk.getCapability(CAPABILITY_CHUNK_ROCK_CRYSTALS, null);
        if (positions != null) {
            if (positions.crystalPositions.remove(pos)) {
                chunk.func_76630_e();
                return true;
            }
            return false;
        }
        return false;
    }

    @SubscribeEvent
    public void attachChunkCap(AttachCapabilitiesEvent<Chunk> chunkEvent) {
        chunkEvent.addCapability(CAP_ROCKCRYSTAL_NAME, (ICapabilityProvider)new RockCrystalPositionProvider());
    }

    public static class ChunkFluidEntryFactory
    implements Callable<RockCrystalPositions> {
        @Override
        public RockCrystalPositions call() throws Exception {
            return new RockCrystalPositions();
        }
    }

    public static class RockCrystalPositionProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final RockCrystalPositions defaultImpl = new RockCrystalPositions();

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability.equals((Object)CAPABILITY_CHUNK_ROCK_CRYSTALS);
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CAPABILITY_CHUNK_ROCK_CRYSTALS.cast((Object)this.defaultImpl) : null);
        }

        public NBTTagCompound serializeNBT() {
            return this.defaultImpl.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.defaultImpl.deserializeNBT(nbt);
        }
    }

    public static class RockCrystalPositions
    implements INBTSerializable<NBTTagCompound> {
        private Set<BlockPos> crystalPositions = new HashSet<BlockPos>();

        public NBTTagCompound serializeNBT() {
            NBTTagCompound cmp = new NBTTagCompound();
            NBTTagList posList = new NBTTagList();
            for (BlockPos exactPos : this.crystalPositions) {
                NBTTagCompound tag = new NBTTagCompound();
                NBTHelper.writeBlockPosToNBT(exactPos, tag);
                posList.func_74742_a((NBTBase)tag);
            }
            cmp.func_74782_a("posList", (NBTBase)posList);
            return cmp;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.crystalPositions.clear();
            NBTTagList entries = nbt.func_150295_c("posList", 10);
            for (int j = 0; j < entries.func_74745_c(); ++j) {
                NBTTagCompound tag = entries.func_150305_b(j);
                this.crystalPositions.add(NBTHelper.readBlockPosFromNBT(tag));
            }
        }
    }
}

