/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.util.data.WorldBlockPos;
import hellfirepvp.astralsorcery.common.util.log.LogCategory;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TreeCaptureHelper {
    public static TreeCaptureHelper eventInstance = new TreeCaptureHelper();
    public static List<WorldBlockPos> oneTimeCatches = Lists.newLinkedList();
    private static List<WeakReference<TreeWatcher>> watchers = Lists.newLinkedList();
    private static Map<WeakReference<TreeWatcher>, List<WorldBlockPos>> cachedEntries = Maps.newHashMap();

    private TreeCaptureHelper() {
    }

    @SubscribeEvent
    public void onTreeGrowth(SaplingGrowTreeEvent event) {
        LogCategory.TREE_BEACON.info(() -> "Captured tree growth at " + event.getPos() + " in dim " + event.getWorld().field_73011_w.getDimension());
        WorldBlockPos pos = new WorldBlockPos(event.getWorld(), event.getPos());
        if (oneTimeCatches.contains((Object)pos)) {
            LogCategory.TREE_BEACON.info(() -> "Expected growth at " + (Object)((Object)pos) + " - skipping!");
            oneTimeCatches.remove((Object)pos);
            return;
        }
        if (watchers.isEmpty()) {
            return;
        }
        Iterator<WeakReference<TreeWatcher>> iterator = watchers.iterator();
        while (iterator.hasNext()) {
            WeakReference<TreeWatcher> watch = iterator.next();
            TreeWatcher watcher = (TreeWatcher)watch.get();
            if (watcher == null) {
                LogCategory.TREE_BEACON.info(() -> "A TreeWatcher timed out (no additional information)");
                iterator.remove();
                continue;
            }
            if (!watcher.watches(pos)) continue;
            LogCategory.TREE_BEACON.info(() -> "TreeWatcher at " + watcher.center + " watches " + (Object)((Object)pos) + " - with squared radius: " + watcher.watchRadiusSq + " (real: " + Math.sqrt(watcher.watchRadiusSq) + ")");
            this.addWatch(watch, pos);
            event.setResult(Event.Result.DENY);
        }
    }

    public static void offerWeakWatcher(TreeWatcher watcher) {
        Iterator<WeakReference<TreeWatcher>> iterator = watchers.iterator();
        while (iterator.hasNext()) {
            WeakReference<TreeWatcher> w = iterator.next();
            TreeWatcher other = (TreeWatcher)w.get();
            if (other == null) {
                iterator.remove();
                continue;
            }
            if (!other.equals(watcher)) continue;
            return;
        }
        LogCategory.TREE_BEACON.info(() -> "New watcher offered and added at " + watcher.center);
        watchers.add(new WeakReference<TreeWatcher>(watcher));
    }

    @Nonnull
    public static List<WorldBlockPos> getAndClearCachedEntries(@Nullable TreeWatcher watcher) {
        if (watcher == null) {
            return Lists.newArrayList();
        }
        if (watchers.isEmpty()) {
            return Lists.newArrayList();
        }
        Iterator<WeakReference<TreeWatcher>> iterator = watchers.iterator();
        while (iterator.hasNext()) {
            WeakReference<TreeWatcher> itW = iterator.next();
            TreeWatcher watch = (TreeWatcher)itW.get();
            if (watch == null) {
                LogCategory.TREE_BEACON.info(() -> "A TreeWatcher timed out (no additional information)");
                iterator.remove();
                continue;
            }
            if (!watcher.equals(watch)) continue;
            List<WorldBlockPos> pos = cachedEntries.get(itW);
            cachedEntries.remove(itW);
            LogCategory.TREE_BEACON.info(() -> "Fetched " + (pos == null ? 0 : pos.size()) + " cached, captured positions for watcher at " + watcher.center);
            return pos == null ? Lists.newArrayList() : pos;
        }
        return Lists.newArrayList();
    }

    private void addWatch(WeakReference<TreeWatcher> watch, WorldBlockPos pos) {
        List entries = cachedEntries.computeIfAbsent(watch, k -> Lists.newLinkedList());
        entries.add(pos);
        LogCategory.TREE_BEACON.info(() -> "Captured " + (Object)((Object)pos) + " - TreeWatcher in total watches " + entries.size());
        Iterator<WeakReference<TreeWatcher>> iterator = cachedEntries.keySet().iterator();
        while (iterator.hasNext()) {
            WeakReference<TreeWatcher> wrT = iterator.next();
            if (wrT.get() != null) continue;
            LogCategory.TREE_BEACON.info(() -> "An empty TreeWatcher was removed from the entry cache");
            iterator.remove();
        }
    }

    public static class TreeWatcher {
        private final int dimId;
        private final BlockPos center;
        private final double watchRadiusSq;

        public TreeWatcher(TileEntity te, double watchRadius) {
            this(te.func_145831_w(), te.func_174877_v(), watchRadius);
        }

        public TreeWatcher(World world, BlockPos center, double watchRadius) {
            this(world.field_73011_w.getDimension(), center, watchRadius);
        }

        public TreeWatcher(int dimId, BlockPos center, double watchRadius) {
            this.dimId = dimId;
            this.center = center;
            this.watchRadiusSq = watchRadius * watchRadius;
        }

        public boolean watches(WorldBlockPos pos) {
            return pos.getWorld().field_73011_w.getDimension() == this.dimId && this.center.func_177951_i((Vec3i)pos) <= this.watchRadiusSq;
        }
    }
}

