/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.item;

import com.oblivioussp.spartanshields.item.ItemShieldBasic;
import com.oblivioussp.spartanshields.util.ConfigHandler;
import com.oblivioussp.spartanshields.util.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemShieldExtraMaterial
extends ItemShieldBasic {
    protected String matOreDict;
    protected boolean doCraftCheck = true;
    protected boolean canBeCrafted = true;

    public ItemShieldExtraMaterial(String unlocName, int maxDamage, Item.ToolMaterial toolMaterial, String materialOreDictName) {
        super(unlocName, maxDamage, toolMaterial);
        this.matOreDict = materialOreDictName;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NonNullList ores;
        if (this.doCraftCheck && worldIn != null && ((ores = OreDictionary.getOres((String)this.matOreDict, (boolean)false)) == null || ores.isEmpty())) {
            this.canBeCrafted = false;
        }
        if (!ConfigHandler.forceDisableUncraftableTooltips && !this.canBeCrafted) {
            tooltip.add(TextFormatting.RED + StringHelper.translateFormattedString("cantCraftMissingMaterial", "tooltip", "spartanshields", StringHelper.translateString(this.matOreDict, "item")));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)this.matOreDict), (ItemStack[])new ItemStack[]{repair});
    }
}

