/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.huntingdim.block;

import java.util.List;
import java.util.Random;
import net.darkhax.bookshelf.block.BlockTileEntity;
import net.darkhax.bookshelf.block.IColorfulBlock;
import net.darkhax.bookshelf.block.property.PropertyObject;
import net.darkhax.bookshelf.util.StackUtils;
import net.darkhax.huntingdim.HuntingDimension;
import net.darkhax.huntingdim.addon.tcon.TconUtils;
import net.darkhax.huntingdim.block.BlockHuntingPortal;
import net.darkhax.huntingdim.block.TileEntityFrame;
import net.darkhax.huntingdim.handler.ConfigurationHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHuntingFrame
extends BlockTileEntity
implements IColorfulBlock {
    public static final PropertyObject<ItemStack> BASE_BLOCK = new PropertyObject("base_block", ItemStack.class);

    public BlockHuntingFrame() {
        super(Material.field_151575_d);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{BASE_BLOCK});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((IExtendedBlockState)state).withProperty(BASE_BLOCK, (Object)BlockHuntingFrame.getVariant(world, pos));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityFrame tile;
        if (worldIn.func_175625_s(pos) instanceof TileEntityFrame && (tile = (TileEntityFrame)worldIn.func_175625_s(pos)) != null) {
            tile.setBaseStack(BlockHuntingFrame.getVariant(stack));
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (Tuple<ItemStack, ItemStack> variant : HuntingDimension.frameVariants) {
            items.add(variant.func_76340_b());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(BlockHuntingFrame.getVariantFromTag(stack.func_77978_p()).func_82833_r());
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return false;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (item instanceof ItemSword || item instanceof ItemBow || Loader.isModLoaded((String)"tconstruct") && TconUtils.isTconWeapon(item)) {
            ((BlockHuntingPortal)HuntingDimension.portal).func_176548_d(worldIn, pos.func_177972_a(facing));
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.func_180495_p(fromPos).func_177230_c() instanceof BlockFire) {
            ((BlockHuntingPortal)HuntingDimension.portal).func_176548_d(worldIn, fromPos);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFrame();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return BlockHuntingFrame.createFrameVariant(BlockHuntingFrame.getVariant((IBlockAccess)world, pos));
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        StackUtils.dropStackInWorld((World)world, (BlockPos)pos, (ItemStack)BlockHuntingFrame.createFrameVariant(BlockHuntingFrame.getVariant((IBlockAccess)world, pos)));
        world.func_175698_g(pos);
        this.func_180652_a(world, pos, explosion);
    }

    public int func_149745_a(Random rnd) {
        return 0;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.func_184812_l_()) {
            StackUtils.dropStackInWorld((World)world, (BlockPos)pos, (ItemStack)BlockHuntingFrame.createFrameVariant(BlockHuntingFrame.getVariant((IBlockAccess)world, pos)));
        }
        return world.func_175698_g(pos);
    }

    public static ItemStack createFrameVariant(ItemStack wood) {
        ItemStack stack = new ItemStack(HuntingDimension.frame);
        StackUtils.prepareStackTag((ItemStack)stack).func_74782_a("BaseBlock", (NBTBase)wood.func_77955_b(new NBTTagCompound()));
        return stack;
    }

    public static ItemStack getVariant(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityFrame) {
            return ((TileEntityFrame)tile).getBaseStack();
        }
        return BlockHuntingFrame.getVariantFromTag(null);
    }

    public static ItemStack getVariant(ItemStack stack) {
        return BlockHuntingFrame.getVariantFromTag(stack.func_77978_p());
    }

    public static ItemStack getVariantFromTag(NBTTagCompound tag) {
        ItemStack tagStack;
        ItemStack stack = new ItemStack(Blocks.field_150364_r);
        if (tag != null && tag.func_74764_b("BaseBlock") && !(tagStack = new ItemStack(tag.func_74775_l("BaseBlock"))).func_190926_b()) {
            stack = tagStack;
        }
        return stack;
    }

    public IBlockColor getColorHandler() {
        return (state, world, pos, index) -> ConfigurationHandler.defaultColorPacked;
    }
}

