/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.sg.m_generators.m_nether.tile;

import com.valkyrieofnight.sg.m_generators.inventory.ContainerGenBase;
import com.valkyrieofnight.sg.m_generators.m_nether.GNether;
import com.valkyrieofnight.sg.m_generators.m_nether.gui.GuiGenNether;
import com.valkyrieofnight.sg.m_generators.tile.TileGenBaseItem;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vliblegacy.lib.util.ConfigCategoryUtil;
import com.valkyrieofnight.vliblegacy.m_guide.registry.TileData;
import com.valkyrieofnight.vliblegacy.m_guide.registry.TileDataProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.fml.common.Optional;

public class TileGenNetherSimple
extends TileGenBaseItem {
    public static ConfigCategoryUtil CCU;
    public static int GEN_CAPACITOR;
    public static int GEN_FUEL_RF_VALUE;
    public static TileDataProvider DP;

    public static void loadConfigs(ConfigCategory config) {
        GEN_CAPACITOR = ConfigCategoryUtil.getInt((ConfigCategory)config, (String)"gen_simple_capacitor", (int)GEN_CAPACITOR, (int)8000, (int)32000000, (String)"How much RF can this gen store?");
        GEN_FUEL_RF_VALUE = ConfigCategoryUtil.getInt((ConfigCategory)config, (String)"gen_simple_fuel_rf_value", (int)GEN_FUEL_RF_VALUE, (int)1, (int)320, (String)"How much RF is generated from a fuel value of 1?");
    }

    public TileGenNetherSimple() {
        super(GEN_CAPACITOR, 0);
    }

    protected boolean isValidFuel(ItemStack fuel) {
        return GNether.NETHER_REG_SIMPLE.getEnergyValue(fuel) > 0;
    }

    @Override
    public EnumFacing[] validConectionDirections() {
        return EnumFacing.field_82609_l;
    }

    protected int getRFTotal(ItemStack stack) {
        return GNether.NETHER_REG_SIMPLE.getEnergyValue(stack);
    }

    @Optional.Method(modid="valkyriecompat")
    public int getIc2Tier() {
        return 1;
    }

    @Override
    protected int getDurationFromFuel(ItemStack fuel) {
        return this.getRFTotal(fuel) / GEN_FUEL_RF_VALUE;
    }

    @Override
    protected int getRFTotalFromFuel(ItemStack fuel) {
        return this.getRFTotal(fuel);
    }

    @Override
    protected boolean isValidInputStack(ItemStack fuel) {
        return GNether.NETHER_REG_SIMPLE.getEnergyValue(fuel) > 0;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiGenNether(player, new ContainerGenBase(player.field_71071_by, this), this);
    }

    static {
        GEN_CAPACITOR = 64000;
        GEN_FUEL_RF_VALUE = 160;
        DP = new TileDataProvider("nether_simple");
        DP.registerData(new TileData("capacitor"){

            public String getLocalizedData() {
                return "" + StringUtils.formatNumber((int)GEN_CAPACITOR);
            }
        });
        DP.registerData(new TileData("energy_tick"){

            public String getLocalizedData() {
                return "" + GEN_FUEL_RF_VALUE;
            }
        });
    }
}

