/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.sg.m_generators.registry;

import com.valkyrieofnight.sg.m_generators.registry.SingleItemEntry;
import com.valkyrieofnight.sg.m_generators.registry.SingleItemJsonRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class SingleItemRegistry {
    public HashMap<ItemStack, Integer> consumables = new HashMap();

    public void register(ItemStack stack, int energy) {
        if (stack != ItemStack.field_190927_a) {
            this.consumables.put(stack, energy);
        }
    }

    public void registerAll(Map<ItemStack, Integer> all) {
        for (ItemStack kp : all.keySet()) {
            this.register(kp, all.get(kp));
        }
    }

    public boolean isValidConsumable(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (ItemStack itemStack : this.consumables.keySet()) {
            if (!stack.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public int getEnergyValue(ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return 0;
        }
        if (this.isValidConsumable(stack)) {
            for (ItemStack itemStack : this.consumables.keySet()) {
                if (!stack.func_77969_a(itemStack)) continue;
                return this.consumables.get(itemStack);
            }
        }
        return 0;
    }

    public Set<ItemStack> getInputs() {
        return this.consumables.keySet();
    }

    public void forEach(BiConsumer<ItemStack, Integer> action) {
        this.consumables.forEach(action);
    }

    public void loadFromJsonRegistry(SingleItemJsonRegistry reg) {
        ArrayList entries = reg.getData();
        for (SingleItemEntry sie : entries) {
            NonNullList<ItemStack> stacks = sie.getItemStacks();
            for (ItemStack is : stacks) {
                if (is == ItemStack.field_190927_a && is == null) continue;
                this.register(is, sie.getEnergy());
            }
        }
    }
}

