/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.blocks.planetAndMoonBlocks;

import com.google.common.base.Predicate;
import com.mjr.extraplanets.ExtraPlanets;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.block.IPlantableBlock;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.client.sounds.GCSounds;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBasicSaturn
extends Block
implements IDetectableResource,
IPlantableBlock,
ITerraformableBlock,
ISortableBlock {
    public static final PropertyEnum<EnumBlockBasic> BASIC_TYPE = PropertyEnum.func_177709_a((String)"basictypesaturn", EnumBlockBasic.class);

    public BlockBasicSaturn(String name) {
        super(Material.field_151576_e);
        this.func_149663_c(name);
        this.func_149647_a(ExtraPlanets.BlocksTab);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.DUNGEON_BRICK) {
            return 40.0f;
        }
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.STONE || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.STONEBRICKS) {
            return 6.0f;
        }
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_COPPER || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_IRON || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_TIN || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_MAGNESIUM || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_SLIME) {
            return 3.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.SURFACE || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.SUB_SURFACE) {
            return 0.5f;
        }
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_COPPER || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_IRON || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_TIN || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_MAGNESIUM || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_SLIME) {
            return 5.0f;
        }
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.DUNGEON_BRICK) {
            return 4.0f;
        }
        return 1.5f;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_SLIME) {
            return Items.field_151123_aH;
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_SLIME) {
            return 0;
        }
        return state.func_177230_c().func_176201_c(state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_SLIME) {
            return 12;
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumBlockBasic blockBasic : EnumBlockBasic.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blockBasic.getMeta()));
        }
    }

    public boolean isValueable(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return false;
    }

    public int requiredLiquidBlocksNearby() {
        return 4;
    }

    public boolean isPlantable(IBlockState arg0) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(10) == 0 && state.func_177230_c() == this && state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.DUNGEON_BRICK) {
            GalacticraftPlanets.spawnParticle((String)"sludgeDrip", (Vector3)new Vector3((double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o(), (double)pos.func_177952_p() + rand.nextDouble()), (Vector3)new Vector3(0.0, 0.0, 0.0), (Object[])new Object[0]);
            if (rand.nextInt(100) == 0) {
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), GCSounds.singleDrip, SoundCategory.AMBIENT, 1.0f, 0.8f + rand.nextFloat() / 5.0f);
            }
        }
    }

    public boolean isTerraformable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        IBlockState stateAbove = world.func_180495_p(pos.func_177984_a());
        return state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.SURFACE && !stateAbove.func_185917_h();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_SLIME) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, 12);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        if (target != Blocks.field_150348_b) {
            return false;
        }
        return state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.STONE;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BASIC_TYPE, (Comparable)((Object)EnumBlockBasic.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBlockBasic)((Object)state.func_177229_b(BASIC_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BASIC_TYPE});
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        switch (meta) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return EnumSortCategoryBlock.ORE;
            }
            case 7: {
                return EnumSortCategoryBlock.INGOT_BLOCK;
            }
            case 8: 
            case 9: {
                return EnumSortCategoryBlock.BRICKS;
            }
        }
        return EnumSortCategoryBlock.GENERAL;
    }

    public static enum EnumBlockBasic implements IStringSerializable
    {
        SURFACE(0, "saturn_surface"),
        SUB_SURFACE(1, "saturn_sub_surface"),
        STONE(2, "saturn_stone"),
        ORE_IRON(3, "saturn_ore_iron"),
        ORE_TIN(4, "saturn_ore_tin"),
        ORE_COPPER(5, "saturn_ore_copper"),
        ORE_MAGNESIUM(6, "saturn_ore_magnesium"),
        MAGNESIUM_BLOCK(7, "saturn_magnesium_block"),
        STONEBRICKS(8, "saturn_stonebricks"),
        DUNGEON_BRICK(9, "saturn_dungeon_brick"),
        BROKEN_INFECTED_STONE(10, "broken_infected_stone"),
        INFECTED_STONE(11, "infected_stone"),
        ORE_SLIME(12, "saturn_ore_slime");

        private final int meta;
        private final String name;

        private EnumBlockBasic(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumBlockBasic byMetadata(int meta) {
            return EnumBlockBasic.values()[meta];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

