/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.entities.bosses;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.items.ExtraPlanets_Items;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityBossBase;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEvolvedGhastBoss
extends EntityBossBase
implements IMob,
IEntityBreathable {
    private int explosionStrength = 1;
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityEvolvedGhastBoss.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityEvolvedGhastBoss(World world) {
        super(world);
        this.func_70105_a(4.0f, 4.0f);
        this.field_70178_ae = true;
        this.field_70728_aV = 5;
        this.field_70765_h = new GhastMoveHelper(this);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIFireballAttack(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        if (!this.field_70170_p.field_72995_K && this.deathTicks == 100) {
            GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_BOSS_DEATH, GCCoreUtil.getDimensionID((World)this.field_70170_p), new Object[]{Float.valueOf(1.5f)}), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID((World)this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public int getFireballStrength() {
        return this.explosionStrength;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if ("fireball".equals(source.func_76355_l()) && source.func_76346_g() instanceof EntityPlayer) {
            super.func_70097_a(source, 10.0f);
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187551_bH;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187555_bJ;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187553_bI;
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int i = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(1 + p_70628_2_);
        for (int j = 0; j < i; ++j) {
            this.func_145779_a(Items.field_151073_bk, 1);
        }
        i = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + p_70628_2_);
        for (int k = 0; k < i; ++k) {
            this.func_145779_a(Items.field_151016_H, 1);
        }
    }

    protected float func_70599_aP() {
        return 10.0f;
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(20) == 0 && super.func_70601_bi() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    public float func_70047_e() {
        return 2.6f;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("ExplosionPower", this.explosionStrength);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("ExplosionPower", 99)) {
            this.explosionStrength = nbt.func_74762_e("ExplosionPower");
        }
    }

    public EntityItem func_70099_a(ItemStack itemStack, float par2) {
        EntityItem EntityItem2 = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)par2, this.field_70161_v, itemStack);
        EntityItem2.field_70181_x = -2.0;
        EntityItem2.func_174869_p();
        if (this.captureDrops) {
            this.capturedDrops.add(EntityItem2);
        } else {
            this.field_70170_p.func_72838_d((Entity)EntityItem2);
        }
        return EntityItem2;
    }

    public boolean canBreath() {
        return true;
    }

    public int getChestTier() {
        return 6;
    }

    public void dropKey() {
        this.func_70099_a(new ItemStack(ExtraPlanets_Items.TIER_6_KEY, 1, 0), 0.5f);
    }

    public ItemStack getGuaranteedLoot(Random rand) {
        List stackList = Config.MORE_PLANETS_COMPATIBILITY ? GalacticraftRegistry.getDungeonLoot((int)5) : GalacticraftRegistry.getDungeonLoot((int)6);
        return ((ItemStack)stackList.get(rand.nextInt(stackList.size()))).func_77946_l();
    }

    public BossInfo.Color getHealthBarColor() {
        return BossInfo.Color.BLUE;
    }

    static class GhastMoveHelper
    extends EntityMoveHelper {
        private final EntityEvolvedGhastBoss parentEntity;
        private int courseChangeCooldown;

        public GhastMoveHelper(EntityEvolvedGhastBoss ghast) {
            super((EntityLiving)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                        this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                        this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private EntityEvolvedGhastBoss parentEntity;

        public AIRandomFly(EntityEvolvedGhastBoss p_i45836_1_) {
            this.parentEntity = p_i45836_1_;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    static class AILookAround
    extends EntityAIBase {
        private EntityEvolvedGhastBoss parentEntity;

        public AILookAround(EntityEvolvedGhastBoss p_i45839_1_) {
            this.parentEntity = p_i45839_1_;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 180.0f / (float)Math.PI;
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                double d0 = 64.0;
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < d0 * d0) {
                    double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 180.0f / (float)Math.PI;
                }
            }
        }
    }

    static class AIFireballAttack
    extends EntityAIBase {
        private EntityEvolvedGhastBoss parentEntity;
        public int attackTimer;

        public AIFireballAttack(EntityEvolvedGhastBoss p_i45837_1_) {
            this.parentEntity = p_i45837_1_;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.parentEntity.setAttacking(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 10) {
                    world.func_180498_a((EntityPlayer)null, 1015, new BlockPos((Entity)this.parentEntity), 0);
                }
                if (this.attackTimer == 20) {
                    Vec3d vec3d = this.parentEntity.func_70676_i(1.0f);
                    double d2 = entitylivingbase.field_70165_t - (this.parentEntity.field_70165_t + vec3d.field_72450_a * 4.0);
                    double d3 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (0.5 + this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f));
                    double d4 = entitylivingbase.field_70161_v - (this.parentEntity.field_70161_v + vec3d.field_72449_c * 4.0);
                    world.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this.parentEntity), 0);
                    EntityLargeFireball entitylargefireball = new EntityLargeFireball(world, (EntityLivingBase)this.parentEntity, d2, d3, d4);
                    entitylargefireball.field_92057_e = this.parentEntity.getFireballStrength();
                    entitylargefireball.field_70165_t = this.parentEntity.field_70165_t + vec3d.field_72450_a * 4.0;
                    entitylargefireball.field_70163_u = this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f) + 0.5;
                    entitylargefireball.field_70161_v = this.parentEntity.field_70161_v + vec3d.field_72449_c * 4.0;
                    world.func_72838_d((Entity)entitylargefireball);
                    this.attackTimer = -40;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.setAttacking(this.attackTimer > 10);
        }
    }
}

