/*
 * Decompiled with CFR 0.152.
 */
package com.seth0067.tothebatpoles;

import com.seth0067.tothebatpoles.Holder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Pole {
    public static boolean isOneBlockNear(EntityPlayer player) {
        World world = player.func_130014_f_();
        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v);
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos checkPos = pos.func_177972_a(facing);
            if (!Pole.isPoleBlock(world, checkPos)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static BlockPos findReachableBlockPos(EntityPlayer player) {
        World world = player.func_130014_f_();
        AxisAlignedBB bb = player.func_174813_aQ();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int y = MathHelper.func_76128_c((double)bb.field_72338_b);
        while ((double)y <= bb.field_72337_e) {
            int x = MathHelper.func_76128_c((double)bb.field_72340_a);
            while ((double)x <= bb.field_72336_d) {
                int z = MathHelper.func_76128_c((double)bb.field_72339_c);
                while ((double)z <= bb.field_72334_f) {
                    pos.func_181079_c(x, y, z);
                    if (Pole.isPoleBlock(world, (BlockPos)pos)) {
                        return pos.func_185334_h();
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        return null;
    }

    @Nullable
    public static Holder findHolderFor(EntityPlayer player) {
        Entity riding = player.func_184187_bx();
        return riding instanceof Holder ? (Holder)riding : null;
    }

    public static void releaseFrom(EntityPlayer player) {
        Holder holder = Pole.findHolderFor(player);
        if (holder != null) {
            holder.func_70106_y();
        }
    }

    public static boolean canBeHeldBy(EntityPlayer player) {
        return player.func_70089_S() && !player.func_175149_v() && !player.func_184218_aH() && !player.func_70093_af();
    }

    public static Vec3d getCenterWithY(BlockPos pos, double y) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
    }

    public static boolean isPoleBlock(World world, BlockPos pos) {
        boolean isIronBar = Pole.isIronBar(world.func_180495_p(pos));
        boolean hasSpaceAround = true;
        if (isIronBar) {
            for (BlockPos checkPos : Pole.getBlocksAroundHoriz(pos, false)) {
                IBlockState state = world.func_180495_p(checkPos);
                if (!state.func_185915_l() && !Pole.isIronBar(state)) continue;
                hasSpaceAround = false;
                break;
            }
        }
        return isIronBar && hasSpaceAround;
    }

    protected static boolean isIronBar(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150411_aY;
    }

    public static boolean isBottomBlock(World world, BlockPos pos) {
        return !Pole.isPoleBlock(world, pos.func_177977_b());
    }

    public static List<BlockPos> getBlocksAroundHoriz(BlockPos startPos, boolean includeCorners) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        posList.add(startPos.func_177976_e());
        posList.add(startPos.func_177974_f());
        posList.add(startPos.func_177978_c());
        posList.add(startPos.func_177968_d());
        if (includeCorners) {
            posList.add(startPos.func_177976_e().func_177978_c());
            posList.add(startPos.func_177976_e().func_177968_d());
            posList.add(startPos.func_177974_f().func_177978_c());
            posList.add(startPos.func_177974_f().func_177968_d());
        }
        return posList;
    }

    public static boolean hasBlocksBelow(World world, BlockPos pos, int amount) {
        int count = 0;
        int offset = 1;
        while (count < amount && Pole.isPoleBlock(world, pos.func_177979_c(offset))) {
            ++count;
            ++offset;
        }
        return count >= amount;
    }

    public static boolean hasBlocksAbove(World world, BlockPos pos, int amount) {
        int count = 0;
        int offset = 1;
        while (count < amount && Pole.isPoleBlock(world, pos.func_177981_b(offset))) {
            ++count;
            ++offset;
        }
        return count >= amount;
    }

    public static boolean isLongEnoughFor(EntityPlayer player, BlockPos pos) {
        World world = player.func_130014_f_();
        int amount = MathHelper.func_76141_d((float)player.field_70131_O);
        return Pole.hasBlocksAbove(world, pos, amount);
    }
}

