/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.itemstages;

import net.darkhax.bookshelf.lib.ItemStackMap;
import net.darkhax.bookshelf.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class StageCompare
implements ItemStackMap.IStackComparator {
    public static final ItemStackMap.IStackComparator INSTANCE = new StageCompare();

    public boolean isValid(ItemStack entryStack, Object second) {
        if (second instanceof ItemStack) {
            ItemStack stack = (ItemStack)second;
            NBTTagCompound first = StackUtils.getTagCleanly((ItemStack)entryStack);
            NBTTagCompound two = StackUtils.getTagCleanly((ItemStack)stack);
            return (!this.isTagEmpty(stack) && StageCompare.arePartiallySimilar((NBTBase)first, (NBTBase)two) || this.isTagEmpty(stack) && this.isTagEmpty(entryStack)) && StackUtils.areStacksSimilar((ItemStack)stack, (ItemStack)entryStack);
        }
        return false;
    }

    private boolean isTagEmpty(ItemStack stack) {
        return !stack.func_77942_o() || stack.func_77978_p().func_150296_c().isEmpty();
    }

    public static boolean arePartiallySimilar(NBTBase one, NBTBase two) {
        if (one == null) {
            return false;
        }
        if (two == null || two.func_82582_d()) {
            return true;
        }
        if (one instanceof NBTTagCompound && two instanceof NBTTagCompound) {
            NBTTagCompound tagOne = (NBTTagCompound)one;
            NBTTagCompound tagTwo = (NBTTagCompound)two;
            for (String key : tagTwo.func_150296_c()) {
                if (StageCompare.arePartiallySimilar(tagOne.func_74781_a(key), tagTwo.func_74781_a(key))) continue;
                return false;
            }
            return true;
        }
        if (one instanceof NBTTagList && two instanceof NBTTagList) {
            NBTTagList listOne = (NBTTagList)one;
            NBTTagList listTwo = (NBTTagList)two;
            for (int i = 0; i < listTwo.func_74745_c(); ++i) {
                boolean similar = false;
                NBTBase tagTwo = listTwo.func_179238_g(i);
                for (int j = 0; j < listOne.func_74745_c(); ++j) {
                    if (!StageCompare.arePartiallySimilar(listOne.func_179238_g(j), tagTwo)) continue;
                    similar = true;
                    break;
                }
                if (similar) continue;
                return false;
            }
            return true;
        }
        return two.equals((Object)one);
    }
}

