/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.itemstages.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.recipes.RecipeRegistry;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.GameStages;
import net.darkhax.itemstages.ConfigurationHandler;
import net.darkhax.itemstages.ItemStages;
import net.darkhax.itemstages.commands.CommandDumpJeiStages;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@JEIPlugin
public class PluginItemStages
implements IModPlugin {
    public static IIngredientBlacklist blacklist;
    public static IIngredientRegistry ingredientRegistry;
    public static IIngredientHelper<ItemStack> ingredientHelper;
    public static IRecipeRegistry recipeRegistry;

    public void register(IModRegistry registry) {
        blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        ingredientRegistry = registry.getIngredientRegistry();
        ingredientHelper = ingredientRegistry.getIngredientHelper(VanillaTypes.ITEM);
        GameStages.COMMAND.addSubcommand((ICommand)new CommandDumpJeiStages());
    }

    @SideOnly(value=Side.CLIENT)
    public static void syncHiddenItems(EntityPlayer player) {
        if (player != null && player.func_130014_f_().field_72995_K && ConfigurationHandler.hideRestrictionsInJEI) {
            if (!Minecraft.func_71410_x().func_152345_ab()) {
                Minecraft.func_71410_x().func_152344_a(() -> PluginItemStages.syncHiddenItems(player));
                return;
            }
            ItemStages.LOG.info("Syncing {} items with JEI!.", new Object[]{ItemStages.ITEM_STAGES.size()});
            long time = System.currentTimeMillis();
            ArrayList itemBlacklist = new ArrayList();
            ArrayList itemWhitelist = new ArrayList();
            ArrayList fluidBlacklist = new ArrayList();
            ArrayList fluidWhitelist = new ArrayList();
            for (String key : ItemStages.SORTED_STAGES.keySet()) {
                List entries = ItemStages.SORTED_STAGES.get((Object)key);
                if (GameStageHelper.hasStage((EntityPlayer)player, (String)key)) {
                    itemWhitelist.addAll(ingredientHelper.expandSubtypes(entries));
                    continue;
                }
                itemBlacklist.addAll(ingredientHelper.expandSubtypes(entries));
            }
            for (String key : ItemStages.FLUID_STAGES.keySet()) {
                if (GameStageHelper.hasStage((EntityPlayer)player, (String)key)) {
                    fluidWhitelist.addAll(ItemStages.FLUID_STAGES.get((Object)key));
                    continue;
                }
                fluidBlacklist.addAll(ItemStages.FLUID_STAGES.get((Object)key));
            }
            if (!itemBlacklist.isEmpty()) {
                ingredientRegistry.removeIngredientsAtRuntime(VanillaTypes.ITEM, itemBlacklist);
            }
            if (!itemWhitelist.isEmpty()) {
                ingredientRegistry.addIngredientsAtRuntime(VanillaTypes.ITEM, itemWhitelist);
            }
            if (!fluidBlacklist.isEmpty()) {
                ingredientRegistry.removeIngredientsAtRuntime(VanillaTypes.FLUID, fluidBlacklist);
            }
            if (!fluidWhitelist.isEmpty()) {
                ingredientRegistry.addIngredientsAtRuntime(VanillaTypes.FLUID, fluidWhitelist);
            }
            RecipeRegistry recipeManager = Internal.getRuntime().getRecipeRegistry();
            for (String categoryStage : ItemStages.recipeCategoryStages.keySet()) {
                boolean hasStage = GameStageHelper.hasStage((EntityPlayer)player, (String)categoryStage);
                for (String category : ItemStages.recipeCategoryStages.get((Object)categoryStage)) {
                    if (hasStage) {
                        recipeManager.unhideRecipeCategory(category);
                        continue;
                    }
                    recipeManager.hideRecipeCategory(category);
                }
            }
            ItemStages.LOG.info("Finished JEI Sync, took " + (System.currentTimeMillis() - time) + "ms. " + itemBlacklist.size() + " hidden, " + itemWhitelist.size() + " shown.", new Object[0]);
        }
    }
}

