/*
 * Decompiled with CFR 0.152.
 */
package com.karjah.betterbedrock.worldGen;

import com.karjah.betterbedrock.Config;
import com.karjah.betterbedrock.event.WorldTick;
import com.karjah.betterbedrock.util.LogHelper;
import java.util.ArrayDeque;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;

public class WorldGenerator
implements IWorldGenerator {
    private boolean ENABLED = Config.RETRO_ENABLED;
    private boolean REBUILD = Config.RETRO_REBUILD;
    private int version = Config.RETRO_VERSION;
    private int[] floor = Config.DIMENSIONS;
    private int[] ceiling = new int[]{-1};
    private String RETRO_NAME = "bbr";
    public static WorldGenerator INSTANCE = new WorldGenerator();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(world, world.func_72964_e(chunkX, chunkZ), true);
    }

    public void generateWorld(World world, Chunk chunk, boolean newGen) {
        if (!newGen && !this.ENABLED) {
            return;
        }
        if (ArrayUtils.contains((int[])this.floor, (int)world.field_73011_w.getDimension())) {
            this.flattenFloor(world, chunk);
        }
        if (ArrayUtils.contains((int[])this.ceiling, (int)world.field_73011_w.getDimension())) {
            this.flattenCeiling(world, chunk);
        }
        if (this.REBUILD) {
            this.rebuildBottomLayer(world, chunk);
        }
        if (!newGen) {
            chunk.func_76630_e();
        }
    }

    private void flattenFloor(World world, Chunk chunk) {
        for (ExtendedBlockStorage storage : chunk.func_76587_i()) {
            if (storage == null) continue;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 1; y < 5; ++y) {
                        if (storage.func_177485_a(x, y, z).func_177230_c() != Blocks.field_150357_h) continue;
                        if (world.field_73011_w.getDimension() == -1) {
                            storage.func_177484_a(x, y, z, Blocks.field_150424_aL.func_176223_P());
                            continue;
                        }
                        storage.func_177484_a(x, y, z, Blocks.field_150348_b.func_176223_P());
                        LogHelper.internal(String.format("Placing stone at %s, %s, %s", chunk.func_76632_l().field_77276_a % 16, y, chunk.func_76632_l().field_77275_b % 16));
                    }
                }
            }
        }
        chunk.func_177427_f(true);
    }

    private void flattenCeiling(World world, Chunk chunk) {
        for (ExtendedBlockStorage storage : chunk.func_76587_i()) {
            if (storage == null) continue;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 121; y < 127; ++y) {
                        if (chunk.func_186032_a(x, y, z).func_177230_c() != Blocks.field_150357_h) continue;
                        chunk.func_177436_a(new BlockPos(x, y, z), Blocks.field_150424_aL.func_176223_P());
                    }
                }
            }
        }
        chunk.func_177427_f(true);
    }

    private void rebuildBottomLayer(World world, Chunk chunk) {
        for (ExtendedBlockStorage storage : chunk.func_76587_i()) {
            if (storage == null) continue;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (chunk.func_186032_a(x, 0, z).func_177230_c() == Blocks.field_150357_h) continue;
                    chunk.func_177436_a(new BlockPos(x, 0, z), Blocks.field_150357_h.func_176223_P());
                }
            }
        }
        chunk.func_177427_f(true);
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        NBTTagCompound tag = event.getData().func_74775_l(this.RETRO_NAME);
        if (!tag.func_74764_b("version")) {
            tag.func_74768_a("version", this.version);
        }
        event.getData().func_74782_a(this.RETRO_NAME, (NBTBase)tag);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        int dim = event.getWorld().field_73011_w.getDimension();
        boolean regen = false;
        NBTTagCompound tag = (NBTTagCompound)event.getData().func_74781_a(this.RETRO_NAME);
        ChunkPos pos = event.getChunk().func_76632_l();
        if (tag != null) {
            boolean generated;
            boolean bl = generated = this.ENABLED && !tag.func_74764_b("version") || tag.func_74762_e("version") != this.version;
            if (generated) {
                LogHelper.internal("Adding chunk " + pos.toString() + " to retrogen queue.");
            }
            regen = true;
        } else {
            regen = this.ENABLED;
        }
        if (regen) {
            ArrayDeque chunks = (ArrayDeque)WorldTick.chunksToGen.get(dim);
            if (chunks == null) {
                WorldTick.chunksToGen.put(dim, new ArrayDeque(128));
                chunks = (ArrayDeque)WorldTick.chunksToGen.get(dim);
            }
            if (chunks != null) {
                chunks.addLast(event.getChunk());
                WorldTick.chunksToGen.put(dim, (Object)chunks);
            }
        }
    }
}

