/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityAILookAtTradePlayerGC;
import micdoodle8.mods.galacticraft.core.entities.EntityAITradePlayerGC;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedWitch;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAlienVillager
extends EntityAgeable
implements IMerchant,
INpc,
IEntityBreathable {
    private int randomTickDivider;
    private boolean isMating;
    private boolean isPlaying;
    private Village villageObj;
    private EntityPlayer buyingPlayer;
    private MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean needsInitilization;
    private int wealth;
    private String lastBuyingPlayer;
    private boolean isLookingForHome;
    private InventoryBasic villagerInventory = new InventoryBasic("Items", false, 8);
    private static final ITradeList[] DEFAULT_TRADE_LIST_MAP = new ITradeList[]{new ListItemForEmeralds(new ItemStack(GCItems.oxMask, 1, 0), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(GCItems.oxTankLight, 1, 235), new PriceInfo(3, 4)), new ListItemForEmeralds(new ItemStack(GCItems.oxygenGear, 1, 0), new PriceInfo(3, 4)), new ListItemForEmeralds(new ItemStack(GCItems.fuelCanister, 1, 317), new PriceInfo(3, 4)), new ListItemForEmeralds(new ItemStack(GCItems.parachute, 1, 0), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(GCItems.battery, 1, 58), new PriceInfo(2, 4)), new ItemAndEmeraldToItem(new ItemStack(GCItems.oilCanister, 1, 1001), new PriceInfo(1, 1), new ItemStack(GCItems.foodItem, 1, 1)), new ListItemForEmeralds(new ItemStack(GCItems.basicItem, 1, 13), new PriceInfo(3, 4)), new ItemAndEmeraldToItem(new ItemStack(GCItems.schematic, 1, 0), new PriceInfo(3, 5), new ItemStack(GCItems.schematic, 1, 1)), new ItemAndEmeraldToItem(new ItemStack(GCItems.schematic, 1, 1), new PriceInfo(3, 5), new ItemStack(GCItems.schematic, 1, 0)), new ItemAndEmeraldToItem(new ItemStack(GCItems.basicItem, 2, 3), new PriceInfo(1, 1), new ItemStack(GCItems.basicItem, 1, 6)), new ItemAndEmeraldToItem(new ItemStack(GCItems.basicItem, 2, 4), new PriceInfo(1, 1), new ItemStack(GCItems.basicItem, 1, 7)), new EmeraldForItems(new ItemStack(Blocks.field_150345_g, 1, 3), new PriceInfo(11, 39))};

    public EntityAlienVillager(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITradePlayerGC(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookAtTradePlayerGC(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.func_98053_h(true);
    }

    protected void func_175500_n() {
        super.func_175500_n();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected void func_70619_bc() {
        if (--this.randomTickDivider <= 0) {
            BlockPos blockpos = new BlockPos((Entity)this);
            this.field_70170_p.func_175714_ae().func_176060_a(blockpos);
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            this.villageObj = this.field_70170_p.func_175714_ae().func_176056_a(blockpos, 32);
            if (this.villageObj == null) {
                this.func_110177_bN();
            } else {
                BlockPos blockpos1 = this.villageObj.func_180608_a();
                this.func_175449_a(blockpos1, (int)((float)this.villageObj.func_75568_b() * 1.0f));
                if (this.isLookingForHome) {
                    this.isLookingForHome = false;
                    this.villageObj.func_82683_b(5);
                }
            }
        }
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization) {
                    for (MerchantRecipe merchantrecipe : this.buyingList) {
                        if (!merchantrecipe.func_82784_g()) continue;
                        merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    this.populateBuyingList();
                    this.needsInitilization = false;
                    if (this.villageObj != null && this.lastBuyingPlayer != null) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                        this.villageObj.func_82688_a(this.lastBuyingPlayer, 1);
                    }
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        boolean bl = flag = itemstack != null && itemstack.func_77973_b() == Items.field_151063_bx;
        if (!(flag || !this.func_70089_S() || this.isTrading() || this.func_70631_g_() || player.func_70093_af())) {
            PlayerGearData gearData = GalacticraftCore.proxy.getGearData(player);
            if (!(this.field_70170_p.field_72995_K || this.buyingList != null && this.buyingList.size() <= 0)) {
                EntityPlayerMP playerMP;
                GCPlayerStats stats;
                if (gearData != null && gearData.getFrequencyModule() != -1) {
                    this.func_70932_a_(player);
                    player.func_180472_a((IMerchant)this);
                } else if (player instanceof EntityPlayerMP && (stats = GCPlayerStats.get((Entity)(playerMP = (EntityPlayerMP)player))).getChatCooldown() == 0) {
                    player.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate("gui.village.warning.no_freq_mod")));
                    stats.setChatCooldown(20);
                }
            }
            player.func_71029_a(StatList.field_188074_H);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Riches", this.wealth);
        if (this.buyingList != null) {
            tagCompound.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.villagerInventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            nbttaglist.func_74742_a((NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)nbttaglist);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.wealth = tagCompund.func_74762_e("Riches");
        if (tagCompund.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = tagCompund.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound);
        }
        NBTTagList nbttaglist = tagCompund.func_150295_c("Inventory", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            ItemStack itemstack = new ItemStack(nbttaglist.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.villagerInventory.func_174894_a(itemstack);
        }
        this.func_98053_h(true);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return this.isTrading() ? SoundEvents.field_187914_gn : SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public boolean isMating() {
        return this.isMating;
    }

    public void setMating(boolean mating) {
        this.isMating = mating;
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void func_70604_c(EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (this.villageObj != null && livingBase != null) {
            this.villageObj.func_75575_a(livingBase);
            if (livingBase instanceof EntityPlayer) {
                int i = -1;
                if (this.func_70631_g_()) {
                    i = -3;
                }
                this.villageObj.func_82688_a(livingBase.func_70005_c_(), i);
                if (this.func_70089_S()) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)13);
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (this.villageObj != null) {
            Entity entity = cause.func_76346_g();
            if (entity != null) {
                if (entity instanceof EntityPlayer) {
                    this.villageObj.func_82688_a(entity.func_70005_c_(), -2);
                } else if (entity instanceof IMob) {
                    this.villageObj.func_82692_h();
                }
            } else {
                EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 16.0);
                if (entityplayer != null) {
                    this.villageObj.func_82692_h();
                }
            }
        }
        super.func_70645_a(cause);
    }

    public void func_70932_a_(EntityPlayer p_70932_1_) {
        this.buyingPlayer = p_70932_1_;
    }

    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
            this.lastBuyingPlayer = this.buyingPlayer != null ? this.buyingPlayer.func_70005_c_() : null;
            i += 5;
        }
        if (recipe.func_77394_a().func_77973_b() == Items.field_151166_bC) {
            this.wealth += recipe.func_77394_a().func_190916_E();
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            if (!stack.func_190926_b()) {
                this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
            } else {
                this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP(), this.func_70647_i());
            }
        }
    }

    public MerchantRecipeList func_70934_b(EntityPlayer p_70934_1_) {
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        return this.buyingList;
    }

    private void populateBuyingList() {
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        for (ITradeList tradeList : DEFAULT_TRADE_LIST_MAP) {
            tradeList.modifyMerchantRecipeList(this.buyingList, this.field_70146_Z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(MerchantRecipeList recipeList) {
    }

    public float func_70047_e() {
        float f = 1.62f;
        if (this.func_70631_g_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.spawnParticles(EnumParticleTypes.HEART);
        } else if (id == 13) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_ANGRY);
        } else if (id == 14) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_HAPPY);
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        return livingdata;
    }

    public EntityAlienVillager createChild(EntityAgeable ageable) {
        EntityAlienVillager entityvillager = new EntityAlienVillager(this.field_70170_p);
        entityvillager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityvillager)), null);
        return entityvillager;
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            EntityEvolvedWitch entitywitch = new EntityEvolvedWitch(this.field_70170_p);
            entitywitch.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitywitch.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entitywitch)), null);
            entitywitch.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                entitywitch.func_96094_a(this.func_95999_t());
                entitywitch.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entitywitch);
            this.func_70106_y();
        }
    }

    public InventoryBasic getVillagerInventory() {
        return this.villagerInventory;
    }

    protected void func_175445_a(EntityItem itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        Item item = itemstack.func_77973_b();
        if (this.canVillagerPickupItem(item)) {
            ItemStack itemstack1 = this.villagerInventory.func_174894_a(itemstack);
            if (itemstack1.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
        }
    }

    private boolean canVillagerPickupItem(Item itemIn) {
        return itemIn == Items.field_151025_P || itemIn == Items.field_151174_bG || itemIn == Items.field_151172_bF || itemIn == Items.field_151015_O || itemIn == Items.field_151014_N;
    }

    public boolean func_175553_cp() {
        return this.hasEnoughItems(1);
    }

    public boolean canAbondonItems() {
        return this.hasEnoughItems(2);
    }

    public boolean func_175557_cr() {
        return !this.hasEnoughItems(5);
    }

    private boolean hasEnoughItems(int multiplier) {
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.villagerInventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b() == Items.field_151025_P && itemstack.func_190916_E() >= 3 * multiplier || itemstack.func_77973_b() == Items.field_151174_bG && itemstack.func_190916_E() >= 12 * multiplier || itemstack.func_77973_b() == Items.field_151172_bF && itemstack.func_190916_E() >= 12 * multiplier) {
                return true;
            }
            if (itemstack.func_77973_b() != Items.field_151015_O || itemstack.func_190916_E() < 9 * multiplier) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canBreath() {
        return true;
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (super.func_174820_d(inventorySlot, itemStackIn)) {
            return true;
        }
        int i = inventorySlot - 300;
        if (i >= 0 && i < this.villagerInventory.func_70302_i_()) {
            this.villagerInventory.func_70299_a(i, itemStackIn);
            return true;
        }
        return false;
    }

    public static class PriceInfo
    extends Tuple<Integer, Integer> {
        public PriceInfo(int p_i45810_1_, int p_i45810_2_) {
            super((Object)p_i45810_1_, (Object)p_i45810_2_);
        }

        public int getPrice(Random rand) {
            return (Integer)this.func_76341_a() >= (Integer)this.func_76340_b() ? (Integer)this.func_76341_a() : (Integer)this.func_76341_a() + rand.nextInt((Integer)this.func_76340_b() - (Integer)this.func_76341_a() + 1);
        }
    }

    public static class ListItemForEmeralds
    implements ITradeList {
        public ItemStack itemToBuy;
        public PriceInfo priceInfo;

        public ListItemForEmeralds(ItemStack stack, PriceInfo priceInfo) {
            this.itemToBuy = stack;
            this.priceInfo = priceInfo;
        }

        @Override
        public void modifyMerchantRecipeList(MerchantRecipeList recipeList, Random random) {
            ItemStack itemstack1;
            ItemStack itemstack;
            int i = 1;
            if (this.priceInfo != null) {
                i = this.priceInfo.getPrice(random);
            }
            if (i < 0) {
                itemstack = new ItemStack(GCItems.itemBasicMoon, 1, 2);
                itemstack1 = new ItemStack(this.itemToBuy.func_77973_b(), -i, this.itemToBuy.func_77960_j());
            } else {
                itemstack = new ItemStack(GCItems.itemBasicMoon, i, 2);
                itemstack1 = new ItemStack(this.itemToBuy.func_77973_b(), 1, this.itemToBuy.func_77960_j());
            }
            recipeList.add((Object)new MerchantRecipe(itemstack, itemstack1));
        }
    }

    public static class ItemAndEmeraldToItem
    implements ITradeList {
        public ItemStack field_179411_a;
        public PriceInfo field_179409_b;
        public ItemStack field_179410_c;

        public ItemAndEmeraldToItem(Item p_i45813_1_, PriceInfo p_i45813_2_, Item p_i45813_3_) {
            this.field_179411_a = new ItemStack(p_i45813_1_);
            this.field_179409_b = p_i45813_2_;
            this.field_179410_c = new ItemStack(p_i45813_3_);
        }

        public ItemAndEmeraldToItem(ItemStack p_i45813_1_, PriceInfo p_i45813_2_, ItemStack p_i45813_3_) {
            this.field_179411_a = p_i45813_1_;
            this.field_179409_b = p_i45813_2_;
            this.field_179410_c = p_i45813_3_;
        }

        @Override
        public void modifyMerchantRecipeList(MerchantRecipeList recipeList, Random random) {
            int i = 1;
            if (this.field_179409_b != null) {
                i = this.field_179409_b.getPrice(random);
            }
            recipeList.add((Object)new MerchantRecipe(this.field_179411_a.func_77946_l(), new ItemStack(GCItems.itemBasicMoon, i, 2), this.field_179410_c.func_77946_l()));
        }
    }

    public static interface ITradeList {
        public void modifyMerchantRecipeList(MerchantRecipeList var1, Random var2);
    }

    public static class EmeraldForItems
    implements ITradeList {
        public ItemStack sellItem;
        public PriceInfo price;

        public EmeraldForItems(ItemStack itemStack, PriceInfo priceIn) {
            this.sellItem = itemStack;
            this.price = priceIn;
        }

        @Override
        public void modifyMerchantRecipeList(MerchantRecipeList recipeList, Random random) {
            int i = 1;
            if (this.price != null) {
                i = this.price.getPrice(random);
            }
            ItemStack tradeStack = this.sellItem.func_77946_l();
            tradeStack.func_190920_e(i);
            recipeList.add((Object)new MerchantRecipe(tradeStack, new ItemStack(GCItems.itemBasicMoon, 1, 2)));
        }
    }
}

