/*
 * Decompiled with CFR 0.152.
 */
package death_compass.capabilities.base;

import com.google.common.base.Preconditions;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;

public abstract class EntityCapability<F extends EntityCapability<F, T, E>, T, E extends Entity> {
    private E entity;
    private boolean dirty = false;

    protected EntityCapability() {
        Preconditions.checkState((boolean)this.getCapabilityClass().isAssignableFrom(this.getClass()), (String)"Entity capability %s must implement %s", (Object)this.getClass().getName(), (Object)this.getCapabilityClass().getName());
    }

    void setEntity(Entity entity) {
        this.entity = entity;
    }

    protected void init() {
    }

    public final E getEntity() {
        return this.entity;
    }

    public abstract ResourceLocation getID();

    protected abstract F getDefaultCapabilityImplementation();

    protected abstract Capability<T> getCapability();

    protected abstract Class<T> getCapabilityClass();

    public final EntityCapability<?, ?, E> getEntityCapability(E entity) {
        if (entity.hasCapability(this.getCapability(), null)) {
            return (EntityCapability)entity.getCapability(this.getCapability(), null);
        }
        return null;
    }

    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
    }

    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
    }

    public abstract boolean isApplicable(Entity var1);

    public final void markDirty() {
        this.dirty = true;
    }

    public final void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public int getTrackingTime() {
        return -1;
    }

    public boolean isPersistent() {
        return false;
    }
}

