/*
 * Decompiled with CFR 0.152.
 */
package death_compass.events;

import death_compass.capabilities.player.IPlayerDeathLocationCapability;
import death_compass.capabilities.player.PlayerDeathLocationCapability;
import java.util.Calendar;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityDeathHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDrops(PlayerDropsEvent event) {
        World world = event.getEntityLiving().field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IPlayerDeathLocationCapability cap = (IPlayerDeathLocationCapability)player.getCapability(PlayerDeathLocationCapability.CAPABILITY_PLAYER_DEATH_LOCATION, null);
            BlockPos posBones = player.func_180425_c();
            cap.setGraveDimension(player.field_70170_p.field_73011_w.getDimension());
            cap.setGraveDimensionName(player.field_70170_p.field_73011_w.func_186058_p().func_186065_b());
            cap.setGraveLocationX(posBones.func_177958_n());
            cap.setGraveLocationZ(posBones.func_177952_p());
            cap.setDeathTime(this.getDeathTimeNow());
        }
    }

    public String getDeathTimeNow() {
        String[] MONTH = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        String month = MONTH[Calendar.getInstance().get(2)];
        String day = String.valueOf(Calendar.getInstance().get(5));
        String year = String.valueOf(Calendar.getInstance().get(1));
        String hour = String.valueOf(Calendar.getInstance().get(11));
        String minute = String.valueOf(Calendar.getInstance().get(12));
        String second = String.valueOf(Calendar.getInstance().get(13));
        String total = (hour.length() == 1 ? '0' + hour : hour) + ":" + (minute.length() == 1 ? '0' + minute : minute) + ":" + (second.length() == 1 ? '0' + second : second) + " " + (day.length() == 1 ? '0' + day : day) + "/" + month + "/" + year;
        return total;
    }
}

