/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.api.interfaces.types;

import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import nmd.primal.core.api.interfaces.types.IType;
import nmd.primal.core.api.interfaces.types.ITypeWood;

public interface ITypeBarrels
extends IType {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);

    @Override
    default public String getDefaultType() {
        return EnumType.byMetadata(0).func_176610_l();
    }

    @Override
    default public void getTypes(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType blocks$enumtype : EnumType.values()) {
            list.add((Object)new ItemStack(item, 1, blocks$enumtype.getMetadata()));
        }
    }

    @Override
    default public float getTypeHardness(IBlockAccess world, BlockPos pos, IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getHardness();
    }

    @Override
    default public float getTypeResistance(IBlockAccess world, BlockPos pos, IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getResistance();
    }

    @Override
    default public int getTypeFlammability(IBlockAccess world, BlockPos pos, IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getFlammability();
    }

    @Override
    default public int getTypeEncouragement(IBlockAccess world, BlockPos pos, IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getEncouragement();
    }

    default public int getTypeVolume(IBlockAccess world, BlockPos pos, IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getVolume();
    }

    default public boolean getTypeHoldsHotFluids(IBlockAccess world, BlockPos pos, IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getHoldsHotFluids();
    }

    @Override
    default public String[] getTypeDictionaryNames(IBlockAccess world, BlockPos pos, IBlockState state) {
        return new String[0];
    }

    public static enum EnumType implements IStringSerializable
    {
        OAK(0, ITypeWood.EnumType.OAK),
        SPRUCE(1, ITypeWood.EnumType.SPRUCE),
        BIRCH(2, ITypeWood.EnumType.BIRCH),
        JUNGLE(3, ITypeWood.EnumType.JUNGLE),
        ACACIA(4, ITypeWood.EnumType.ACACIA),
        DARK_OAK(5, ITypeWood.EnumType.DARK_OAK),
        IRONWOOD(6, ITypeWood.EnumType.IRONWOOD, true),
        YEW(7, ITypeWood.EnumType.YEW),
        LACQUER(8, ITypeWood.EnumType.LACQUER, true),
        CORYPHA(9, ITypeWood.EnumType.CORYPHA, true);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor mapColor;
        private final float hardness;
        private final float resistance;
        private final int flammability;
        private final int encouragement;
        private final int volume;
        private final ITypeWood.EnumType planks;
        private final boolean canHoldHotFluids;

        private EnumType(int meta, String name, int volume, MapColor color, ITypeWood.EnumType planks, float hardness, float resistance, int flammability, int encouragement, boolean canHoldHotFluids) {
            this.meta = meta;
            this.name = name;
            this.volume = volume;
            this.mapColor = color;
            this.planks = planks;
            this.hardness = hardness;
            this.resistance = resistance;
            this.flammability = flammability;
            this.encouragement = encouragement;
            this.canHoldHotFluids = canHoldHotFluids;
        }

        private EnumType(int meta, ITypeWood.EnumType planks, boolean canHoldHotFluids) {
            this(meta, planks.name().toLowerCase(), Math.round(planks.getHardness() * 5000.0f / 2.0f / 1000.0f) * 1000, planks.getMapColor(), planks, planks.getHardness(), planks.getResistance(), planks.getFlammability(), planks.getEncouragement(), canHoldHotFluids);
        }

        private EnumType(int meta, ITypeWood.EnumType planks) {
            this(meta, planks, false);
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public float getHardness() {
            return this.hardness;
        }

        public float getResistance() {
            return this.resistance;
        }

        public int getMetadata() {
            return this.meta;
        }

        public int getFlammability() {
            return this.flammability;
        }

        public int getEncouragement() {
            return this.encouragement;
        }

        public int getVolume() {
            return this.volume;
        }

        public boolean getHoldsHotFluids() {
            return this.canHoldHotFluids;
        }

        public static EnumType byName(String name) {
            for (EnumType blocks$enumtype : EnumType.values()) {
                if (!blocks$enumtype.func_176610_l().equals(name)) continue;
                return blocks$enumtype;
            }
            return IRONWOOD;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blocks$enumtype;
                EnumType.META_LOOKUP[blocks$enumtype.getMetadata()] = blocks$enumtype = enumTypeArray[i];
            }
        }
    }
}

