/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.api.interfaces.types;

import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public interface ITypeBrick {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");

    default public String getDefaultType() {
        return EnumType.byMetadata(0).func_176610_l();
    }

    default public void getTypes(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType blocks$enumtype : EnumType.values()) {
            list.add((Object)new ItemStack(item, 1, blocks$enumtype.getMetadata()));
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        NORMAL(0, "normal", MapColor.field_151665_m),
        SMOOTH(1, "smooth", MapColor.field_151665_m),
        STACKED(2, "stacked", MapColor.field_151665_m),
        BRICK(3, "brick", MapColor.field_151665_m),
        COBBLED(4, "cobbled", MapColor.field_151665_m),
        CARVED(5, "carved", MapColor.field_151665_m),
        FACE(6, "face", MapColor.field_151665_m),
        PILLAR(7, "pillar", MapColor.field_151665_m);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor mapColor;

        private EnumType(int meta, String name, MapColor color) {
            this.meta = meta;
            this.name = name;
            this.mapColor = color;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public static boolean isSolid(IBlockState state) {
            return state.func_177229_b(TYPE) != PILLAR;
        }

        public static boolean isPillar(IBlockState state) {
            return state.func_177229_b(TYPE) == PILLAR;
        }

        public static boolean canConnectTo(IBlockState state, IBlockAccess world, BlockPos pos) {
            return EnumType.isPillar(state) && world.func_180495_p(pos).func_185917_h();
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blocks$enumtype;
                EnumType.META_LOOKUP[blocks$enumtype.getMetadata()] = blocks$enumtype = enumTypeArray[i];
            }
        }
    }
}

