/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.api.interfaces.types;

import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import nmd.primal.core.api.interfaces.types.IType;

public interface ITypePlanks
extends IType {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);

    @Override
    default public String getDefaultType() {
        return EnumType.byMetadata(0).func_176610_l();
    }

    @Override
    default public void getTypes(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType blocks$enumtype : EnumType.values()) {
            list.add((Object)new ItemStack(item, 1, blocks$enumtype.getMetadata()));
        }
    }

    @Override
    default public float getTypeHardness(IBlockAccess world, BlockPos pos, IBlockState state) {
        return state.func_177230_c() instanceof ITypePlanks ? ((EnumType)((Object)state.func_177229_b(TYPE))).getHardness() : 2.0f;
    }

    @Override
    default public float getTypeResistance(IBlockAccess world, BlockPos pos, IBlockState state) {
        return state.func_177230_c() instanceof ITypePlanks ? ((EnumType)((Object)state.func_177229_b(TYPE))).getResistance() : 5.0f;
    }

    @Override
    default public int getTypeFlammability(IBlockAccess world, BlockPos pos, IBlockState state) {
        return state.func_177230_c() instanceof ITypePlanks ? ((EnumType)((Object)state.func_177229_b(TYPE))).getFlammability() : 5;
    }

    @Override
    default public int getTypeEncouragement(IBlockAccess world, BlockPos pos, IBlockState state) {
        return state.func_177230_c() instanceof ITypePlanks ? ((EnumType)((Object)state.func_177229_b(TYPE))).getEncouragement() : 20;
    }

    @Override
    default public String[] getTypeDictionaryNames(IBlockAccess world, BlockPos pos, IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getOreNames();
    }

    public static enum EnumType implements IStringSerializable
    {
        IRONWOOD(0, "ironwood", MapColor.field_151654_J, 4.0f, 10.0f, 0, 0, "plankIronwood", "plankWood"),
        YEW(1, "yew", MapColor.field_151663_o, 2.0f, 5.0f, 5, 20, "plankYew", "plankWood"),
        LACQUER(2, "lacquer", MapColor.field_151663_o, 3.5f, 8.0f, 2, 0, "plankLacquer", "plankTreatedWood", "plankWood"),
        CORYPHA(3, "corypha", MapColor.field_151655_K, 5.0f, 20.0f, 0, 0, "plankCorypha", "plankWood");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor mapColor;
        private final float hardness;
        private final float resistance;
        private final int flammability;
        private final int encouragement;
        private final String[] oreNames;

        private EnumType(int meta, String name, MapColor color, float hardness, float resistance, int flammability, int encouragement, String ... oreNames) {
            this.meta = meta;
            this.name = name;
            this.mapColor = color;
            this.hardness = hardness;
            this.resistance = resistance;
            this.flammability = flammability;
            this.encouragement = encouragement;
            this.oreNames = oreNames;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public float getHardness() {
            return this.hardness;
        }

        public float getResistance() {
            return this.resistance;
        }

        public int getMetadata() {
            return this.meta;
        }

        public int getFlammability() {
            return this.flammability;
        }

        public int getEncouragement() {
            return this.encouragement;
        }

        public String[] getOreNames() {
            return this.oreNames;
        }

        public static EnumType byName(String name) {
            for (EnumType blocks$enumtype : EnumType.values()) {
                if (!blocks$enumtype.func_176610_l().equals(name)) continue;
                return blocks$enumtype;
            }
            return IRONWOOD;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blocks$enumtype;
                EnumType.META_LOOKUP[blocks$enumtype.getMetadata()] = blocks$enumtype = enumTypeArray[i];
            }
        }
    }
}

