/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.client.render.tiles;

import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.interfaces.IRenderSpecial;
import nmd.primal.core.client.render.tiles.AbstractTESR;
import nmd.primal.core.client.render.tiles.TileRenderHelper;
import nmd.primal.core.common.tiles.machines.TileHibachi;

@SideOnly(value=Side.CLIENT)
public class RenderHibachi
extends AbstractTESR<TileHibachi> {
    @Override
    public boolean shouldRender(TileHibachi tile, World world, BlockPos pos, IBlockState state) {
        return tile.getCraftingHandler() != null || tile.getFuelHandler() != null;
    }

    @Override
    public void renderTile(TileHibachi tile, World world, BlockPos pos, IBlockState state, double x, double y, double z, float partialTicks, int destroyStage) {
        TileRenderHelper.initRenderAndRotate(state, x, y, z);
        ItemStackHandler handler = tile.getCraftingHandler();
        for (int i = 0; i < handler.getSlots(); ++i) {
            float rotation;
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            boolean is_block = stack.func_77973_b() instanceof ItemBlock;
            boolean is_special = stack.func_77973_b() instanceof IRenderSpecial;
            float scale = is_block ? 0.8f : (is_special ? 1.2f : 1.5f);
            float f = rotation = is_block || is_special ? 180.0f : 90.0f;
            float offset_y = is_block ? 1.95f : (is_special ? 1.265f : 1.55f);
            float offset_x = (i & 1) == 0 ? 0.0f : 1.4f;
            float offset_z = i < 2 ? 0.0f : 1.5f;
            TileRenderHelper.renderItem(world, this.renderItem, stack, -rotation, scale, offset_x, offset_y, offset_z, 0.2f);
        }
        ItemStack stack = tile.getFuelHandler().getStackInSlot(0);
        if (!stack.func_190926_b()) {
            boolean is_block = stack.func_77973_b() instanceof ItemBlock || stack.func_77973_b() instanceof IRenderSpecial;
            float scale = is_block ? 0.8f : 1.5f;
            float rotation = is_block ? 180.0f : 90.0f;
            float offset_y = is_block ? 0.0f : -0.5f;
            TileRenderHelper.renderItem(world, this.renderItem, stack, -rotation, scale, 0.75f, offset_y, 1.0f, 0.2f);
        }
    }
}

