/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.interfaces.crafting.IDictionaryName;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.RegistryHelper;

public abstract class AbstractFalling
extends BlockFalling
implements IDictionaryName<Block> {
    protected static ThreadLocalRandom RANDOM = PrimalCore.RANDOM;
    private MapColor map_color;
    private String[] dictionary_names;

    public AbstractFalling(Material material, MapColor map_color) {
        super(material);
        this.map_color = map_color;
    }

    public AbstractFalling(Material material) {
        this(material, material.func_151565_r());
    }

    @Override
    public Block setDictionaryNames(String ... strings) {
        this.dictionary_names = strings;
        return this;
    }

    @Override
    public String[] getDictionaryNames() {
        return this.dictionary_names;
    }

    @Override
    public void registerDictionaryNames() {
        for (String name : this.getDictionaryNames()) {
            RegistryHelper.registerDictionaryNames(new ItemStack((Block)this), name);
        }
    }

    public String getName() {
        return this.getRegistryName().toString();
    }

    public boolean isWet(World world, BlockPos pos) {
        return world.func_175727_C(pos.func_177984_a());
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.map_color;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_189876_x(IBlockState state) {
        return -16777216;
    }
}

