/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.lighting;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IEphemeral;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.AbstractBlock;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FireHelper;

public class IgnisFatuus
extends AbstractBlock
implements ILit,
IEphemeral {
    private int light_level;
    private int burn_chance;

    public IgnisFatuus() {
        super(Material.field_151581_o);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(-1.0f);
        this.func_149752_b(0.0f);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STABILITY, (Comparable)((Object)IEphemeral.EnumStability.STABLE)));
        this.light_level = 12;
        this.burn_chance = 60;
    }

    @Override
    public int getDecayRate() {
        return 2600;
    }

    public int func_149738_a(World world) {
        return this.getDecayRate();
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K && !this.isStable(state)) {
            world.func_175684_a(pos, (Block)this, this.getDecayRate());
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && !this.isStable(state)) {
            world.func_175655_b(pos, false);
        }
    }

    @Override
    public boolean isLit(IBlockAccess world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public boolean canLite(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean doExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        if (!world.field_72995_K) {
            FireHelper.makeSmoke(world, pos, 16);
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            world.func_175698_g(pos);
        }
        return true;
    }

    @Override
    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.burn_chance;
    }

    public boolean isAir(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (PrimalAPI.randomCheck(this.burn_chance) && !entity.func_70026_G() && entity instanceof EntityLivingBase) {
            entity.func_70015_d(2);
            FireHelper.makeSmoke(world, pos, 8);
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return null;
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DAMAGE_FIRE;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        return 0xF000F0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_IGNIS_FATUUS;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.light_level;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (CommonUtils.isExposedToSun(world, pos)) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + (double)0.35f;
            double d2 = (double)pos.func_177952_p() + 0.5;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        } else {
            double x = pos.func_177958_n();
            double z = pos.func_177952_p();
            double y = (double)pos.func_177956_o() + 0.25;
            for (int i = 0; i <= RANDOM.nextInt(3, 6); ++i) {
                PrimalCore.PROXY.spawnParticle(PrimalAPI.Particles.IGNIS, world, x + RANDOM.nextDouble(0.4, 0.6), y + RANDOM.nextDouble(0.025, 0.1), z + RANDOM.nextDouble(0.4, 0.6), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STABILITY});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STABILITY, (Comparable)((Object)IEphemeral.EnumStability.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return this.getStability(state).getMetadata();
    }
}

