/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.lighting;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMaterialMatcher;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.init.ModConfig;

public class JackOLanern
extends BlockPumpkin
implements IFace,
ILit {
    private static final Predicate<IBlockState> IS_PUMPKIN = new Predicate<IBlockState>(){

        public boolean apply(@Nullable IBlockState apply) {
            return apply != null && apply.func_177230_c() == PrimalAPI.Blocks.JACK_O_LANTERN;
        }
    };
    private boolean CAN_EXPIRE;
    private int LIGHT_LEVEL;
    private BlockPattern snowmanBasePattern;
    private BlockPattern snowmanPattern;
    private BlockPattern golemBasePattern;
    private BlockPattern golemPattern;

    public JackOLanern() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)IFace.FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(1.0f);
        this.func_149675_a(true);
        this.CAN_EXPIRE = ModConfig.Lighting.JACK_CAN_EXPIRE;
        this.LIGHT_LEVEL = (int)(15.0f * (float)ModConfig.Lighting.JACK_LIGHT_LEVEL);
    }

    @Override
    public boolean canLite(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean doLite(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        if (!this.isLit((IBlockAccess)world, pos, state) && world.func_180501_a(pos, state.func_177231_a((IProperty)ILit.LIT), 2)) {
            FireHelper.makeSmoke(world, pos, 16);
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        return false;
    }

    @Override
    public boolean doExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        if (this.isLit((IBlockAccess)world, pos, state) && world.func_180501_a(pos, state.func_177231_a((IProperty)ILit.LIT), 2)) {
            FireHelper.makeSmoke(world, pos, 16);
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        return false;
    }

    public static boolean isLit3(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ILit.LIT);
    }

    public void func_176224_k(World world, BlockPos pos) {
        if (!world.field_72995_K && this.isLit((IBlockAccess)world, pos, world.func_180495_p(pos)) && PrimalAPI.randomCheckFail(ModConfig.Lighting.SMOKE_LANTERN_CHANCE)) {
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            FireHelper.makeSmoke(world, pos);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && this.isLit((IBlockAccess)world, pos, state) && this.CAN_EXPIRE && ModConfig.Lighting.TORCH_LIFESPAN > 0) {
            int lifetime;
            int n = lifetime = ModConfig.Lighting.TORCHES_DIE ? ModConfig.Lighting.TORCH_LIFESPAN * 8 : 0;
            if (PrimalAPI.randomCheckFail(lifetime)) {
                this.doExtinguish(world, pos, state, EnumFacing.UP, null);
            }
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isLit(world, pos, state) ? this.LIGHT_LEVEL : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IFace.FACING, ILit.LIT});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)IFace.FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IFace.FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    protected BlockPattern func_176392_j() {
        if (this.snowmanBasePattern == null) {
            this.snowmanBasePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{" ", "#", "#"}).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150433_aE))).func_177661_b();
        }
        return this.snowmanBasePattern;
    }

    protected BlockPattern func_176391_l() {
        if (this.snowmanPattern == null) {
            this.snowmanPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"^", "#", "#"}).func_177662_a('^', BlockWorldState.func_177510_a(IS_PUMPKIN)).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150433_aE))).func_177661_b();
        }
        return this.snowmanPattern;
    }

    protected BlockPattern func_176389_S() {
        if (this.golemBasePattern == null) {
            this.golemBasePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"~ ~", "###", "~#~"}).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150339_S))).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.golemBasePattern;
    }

    protected BlockPattern func_176388_T() {
        if (this.golemPattern == null) {
            this.golemPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"~^~", "###", "~#~"}).func_177662_a('^', BlockWorldState.func_177510_a(IS_PUMPKIN)).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150339_S))).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.golemPattern;
    }
}

