/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.lighting;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.AbstractBlock;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;
import nmd.primal.core.common.init.ModConfig;

public class Lantern
extends AbstractBlock
implements IFace,
ILit,
IPickup {
    private boolean HAS_TORCH;
    private boolean CAN_EXPIRE;
    private int LIGHT_LEVEL;

    public Lantern(boolean torch, boolean expire, float light) {
        super(Material.field_151573_f, MapColor.field_151646_E);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
        this.func_149675_a(expire);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)));
        this.HAS_TORCH = torch;
        this.CAN_EXPIRE = expire;
        this.LIGHT_LEVEL = (int)(15.0f * light);
    }

    public Lantern() {
        this(false, false, 0.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.lantern_torch"));
        tooltip.add(TextFormatting.BLUE + I18n.func_74838_a((String)"tooltip.info.primal.lantern_light"));
        tooltip.add(TextFormatting.BLUE + I18n.func_74838_a((String)"tooltip.info.primal.lantern_warning"));
    }

    @Override
    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)IFace.FACING_FULL);
    }

    @Override
    public IBlockState getReplacementBlock(World world, BlockPos pos, IBlockState state) {
        return PrimalAPI.Blocks.LANTERN_EMPTY.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)this.getFacing(state));
    }

    @Override
    public boolean doPickup(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityPlayer player, EnumHand hand) {
        if (this.hasTorch(state)) {
            ItemStack drop = ItemStack.field_190927_a;
            if (this == PrimalAPI.Blocks.LANTERN_TORCH) {
                if (this.isLit((IBlockAccess)world, pos, state)) {
                    world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.5f, RANDOM.nextFloat() + 2.6f - RANDOM.nextFloat() * 0.8f);
                    drop = new ItemStack(Blocks.field_150478_aa);
                } else {
                    drop = new ItemStack(PrimalAPI.Blocks.TORCH_WOOD);
                }
            } else if (this == PrimalAPI.Blocks.LANTERN_NETHER) {
                if (this.isLit((IBlockAccess)world, pos, state)) {
                    world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.5f, RANDOM.nextFloat() + 2.6f - RANDOM.nextFloat() * 0.8f);
                    drop = new ItemStack(PrimalAPI.Items.TORCH_NETHER_LIT);
                } else {
                    drop = new ItemStack(PrimalAPI.Blocks.TORCH_NETHER);
                }
            } else if (this == PrimalAPI.Blocks.LANTERN_IGNIS) {
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.5f, RANDOM.nextFloat() + 2.6f - RANDOM.nextFloat() * 0.8f);
                drop = new ItemStack(PrimalAPI.Blocks.IGNIS_FATUUS);
            } else if (this == PrimalAPI.Blocks.LANTERN_REDSTONE) {
                drop = new ItemStack(Blocks.field_150429_aA);
            }
            if (world.func_180501_a(pos, this.getReplacementBlock(world, pos, state), 2)) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)drop);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLit(IBlockAccess world, BlockPos pos, IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ILit.LIT) != false || BlockMultiplexer.forBlock(PrimalAPI.Blocks.LANTERN_IGNIS, PrimalAPI.Blocks.LANTERN_REDSTONE).apply(state);
    }

    @Override
    public boolean canLite(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        return this.hasTorch(state) && !BlockMultiplexer.forBlock(PrimalAPI.Blocks.LANTERN_IGNIS, PrimalAPI.Blocks.LANTERN_REDSTONE).apply(state);
    }

    @Override
    public boolean canExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        return !BlockMultiplexer.forBlock(PrimalAPI.Blocks.LANTERN_IGNIS, PrimalAPI.Blocks.LANTERN_REDSTONE).apply(state);
    }

    public boolean hasTorch(IBlockState state) {
        return state.func_177230_c() != PrimalAPI.Blocks.LANTERN_EMPTY;
    }

    public boolean addTorch(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!stack.func_190926_b() && !this.hasTorch(state)) {
            EnumFacing facing = this.getFacing(state);
            IBlockState torch = world.func_180495_p(pos);
            if (stack.func_77969_a(new ItemStack(Blocks.field_150478_aa))) {
                torch = PrimalAPI.Blocks.LANTERN_TORCH.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)facing).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true));
            }
            if (stack.func_77969_a(new ItemStack(PrimalAPI.Blocks.TORCH_WOOD))) {
                torch = PrimalAPI.Blocks.LANTERN_TORCH.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)facing).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false));
            }
            if (stack.func_77969_a(new ItemStack(PrimalAPI.Items.TORCH_NETHER_LIT))) {
                torch = PrimalAPI.Blocks.LANTERN_NETHER.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)facing).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true));
            }
            if (stack.func_77969_a(new ItemStack(PrimalAPI.Blocks.TORCH_NETHER))) {
                torch = PrimalAPI.Blocks.LANTERN_NETHER.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)facing).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false));
            }
            if (stack.func_77969_a(new ItemStack(Blocks.field_150429_aA))) {
                torch = PrimalAPI.Blocks.LANTERN_REDSTONE.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)facing).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true));
            }
            if (stack.func_77969_a(new ItemStack(PrimalAPI.Blocks.IGNIS_FATUUS))) {
                torch = PrimalAPI.Blocks.LANTERN_IGNIS.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)facing).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true));
            }
            if (stack.func_77969_a(new ItemStack(PrimalAPI.Items.SEARING_EMBER))) {
                torch = PrimalAPI.Blocks.LANTERN_IGNIS.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)facing).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true));
            }
            if (world.func_180501_a(pos, torch, 2)) {
                PlayerHelper.useStack(player, hand, stack);
                return true;
            }
        }
        return false;
    }

    public void func_176224_k(World world, BlockPos pos) {
        if (!world.field_72995_K && this.isLit((IBlockAccess)world, pos, world.func_180495_p(pos)) && PrimalAPI.randomCheckFail(ModConfig.Lighting.SMOKE_LANTERN_CHANCE)) {
            FireHelper.makeSmoke(world, pos);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && this.isLit((IBlockAccess)world, pos, state) && this.CAN_EXPIRE && ModConfig.Lighting.TORCH_LIFESPAN > 0) {
            int lifetime;
            int n = lifetime = ModConfig.Lighting.TORCHES_DIE ? ModConfig.Lighting.TORCH_LIFESPAN * 8 : 0;
            if (PrimalAPI.randomCheckFail(lifetime)) {
                this.doExtinguish(world, pos, state, EnumFacing.UP, null);
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (this.checkForDrop(world, pos, state) && !Lantern.canPlaceBlock(world, pos, ((EnumFacing)state.func_177229_b((IProperty)IFace.FACING_FULL)).func_176734_d())) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    private boolean checkForDrop(World world, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(world, pos)) {
            return true;
        }
        this.func_176226_b(world, pos, state, 0);
        world.func_175698_g(pos);
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (this.isLit((IBlockAccess)world, pos, state)) {
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack(PrimalAPI.Blocks.LANTERN_EMPTY, 1));
        if (this == PrimalAPI.Blocks.LANTERN_REDSTONE) {
            drops.add(new ItemStack(Blocks.field_150429_aA, 1));
        } else if (this == PrimalAPI.Blocks.LANTERN_TORCH) {
            drops.add(new ItemStack(PrimalAPI.Blocks.TORCH_WOOD, 1));
        } else if (this == PrimalAPI.Blocks.LANTERN_NETHER) {
            drops.add(new ItemStack(PrimalAPI.Blocks.TORCH_NETHER, 1));
        }
        return drops;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isLit(world, pos, state) ? this.LIGHT_LEVEL : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.55;
        double z = (double)pos.func_177952_p() + 0.5;
        if (this == PrimalAPI.Blocks.LANTERN_REDSTONE) {
            world.func_175688_a(EnumParticleTypes.REDSTONE, x += (rand.nextDouble() - 0.5) * 0.2, y += (rand.nextDouble() - 0.5) * 0.2, z += (rand.nextDouble() - 0.5) * 0.2, 0.0, 0.0, 0.0, new int[0]);
        } else if (this == PrimalAPI.Blocks.LANTERN_IGNIS) {
            y = (double)pos.func_177956_o() + 0.35;
            PrimalCore.PROXY.spawnParticle(PrimalAPI.Particles.IGNIS, world, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        } else if (this.isLit((IBlockAccess)world, pos, state)) {
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b((IProperty)IFace.FACING_FULL) == EnumFacing.UP ? PrimalAPI.Bounds.AABB_LANTERN_UP : PrimalAPI.Bounds.AABB_LANTERN;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        boolean lit = this == PrimalAPI.Blocks.LANTERN_REDSTONE || this == PrimalAPI.Blocks.LANTERN_IGNIS;
        return Lantern.canPlaceBlock(world, pos, face.func_176734_d()) ? this.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)face).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(lit)) : this.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(lit));
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return Lantern.canPlaceBlock(world, pos, side.func_176734_d());
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!Lantern.canPlaceBlock(world, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private static boolean canPlaceBlock(World world, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing);
        IBlockState state = world.func_180495_p(blockpos);
        return state.isSideSolid((IBlockAccess)world, pos, facing.func_176734_d()) || state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IFace.FACING_FULL, ILit.LIT});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing;
        switch (meta & 7) {
            case 0: {
                enumfacing = EnumFacing.DOWN;
                break;
            }
            case 1: {
                enumfacing = EnumFacing.EAST;
                break;
            }
            case 2: {
                enumfacing = EnumFacing.WEST;
                break;
            }
            case 3: {
                enumfacing = EnumFacing.SOUTH;
                break;
            }
            case 4: {
                enumfacing = EnumFacing.NORTH;
                break;
            }
            default: {
                enumfacing = EnumFacing.UP;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)enumfacing).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i;
        switch ((EnumFacing)state.func_177229_b((IProperty)IFace.FACING_FULL)) {
            case EAST: {
                i = 1;
                break;
            }
            case WEST: {
                i = 2;
                break;
            }
            case SOUTH: {
                i = 3;
                break;
            }
            case NORTH: {
                i = 4;
                break;
            }
            default: {
                i = 5;
                break;
            }
            case DOWN: {
                i = 0;
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)IFace.FACING_FULL)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)IFace.FACING_FULL)));
    }
}

