/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.machines;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.events.CauldronEvent;
import nmd.primal.core.api.events.CauldronPickupEvent;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.common.blocks.AbstractTank;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.tools.CauldronLadle;
import nmd.primal.core.common.recipes.inworld.BottleRecipe;
import nmd.primal.core.common.recipes.tile.CauldronRecipe;
import nmd.primal.core.common.tiles.machines.TileCauldron;

public class Cauldron
extends AbstractTank<TileCauldron>
implements ISchedule,
IPickup {
    public Cauldron() {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(10.0f);
        this.func_149752_b(20.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.setFireProof(true);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileCauldron();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        String fluid_info = I18n.func_74838_a((String)"tooltip.info.primal.abstract_tank_size") + ": " + TileCauldron.getCapacity() + "mb";
        NBTTagCompound nbt = stack.func_179543_a("BlockEntityTag");
        if (nbt != null) {
            FluidStack fluid = FluidRegistry.getFluidStack((String)nbt.func_74779_i("FluidName"), (int)nbt.func_74762_e("Amount"));
            if (fluid != null) {
                fluid_info = I18n.func_74838_a((String)"tooltip.info.primal.abstract_tank_fluid") + ": " + fluid.getLocalizedName() + " " + fluid.amount + "/" + TileCauldron.getCapacity() + "mb";
            }
            if (nbt.func_74767_n("superhot")) {
                tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"tooltip.info.primal.cauldron_warning"));
            }
        }
        tooltip.add(TextFormatting.BLUE + fluid_info);
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.cauldron_items"));
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_requires_heat"));
        tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"tooltip.info.primal.abstract_produces_waste"));
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    @Override
    public ItemStack getLid(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(PrimalAPI.Items.CAULDRON_LID);
    }

    @Override
    public boolean canPickup(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && !tile.func_145837_r() && tile instanceof TileCauldron && ((TileCauldron)tile).isCovered();
    }

    @Override
    public boolean doPickup(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileCauldron && ((TileCauldron)tile).isCovered()) {
            if (face == EnumFacing.UP) {
                CauldronEvent.Open open = new CauldronEvent.Open((TileCauldron)tile, player);
                if (MinecraftForge.EVENT_BUS.post((Event)open)) {
                    return false;
                }
                ((TileCauldron)tile).setCovered(false);
                ((TileCauldron)tile).updateBlock();
                this.playSoundLid(world, pos);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.getLid(world, pos, state));
                return true;
            }
            ItemStack pickup_stack = this.func_185473_a(world, pos, state);
            CauldronPickupEvent.Pre pre = new CauldronPickupEvent.Pre((TileCauldron)tile, player, pickup_stack);
            if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
                return false;
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)pickup_stack);
            world.func_175666_e(pos, state.func_177230_c());
            world.func_175656_a(pos, this.getReplacementBlock(world, pos, state));
            world.func_175713_t(pos);
            MinecraftForge.EVENT_BUS.post((Event)new CauldronPickupEvent.Post((TileCauldron)tile, player, pickup_stack));
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, true);
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt((int)Math.floor((float)ModConfig.Machines.CAULDRON_TICK_RATE * 0.75f), ModConfig.Machines.CAULDRON_TICK_RATE);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.field_72995_K) {
            return;
        }
        TileCauldron tile = (TileCauldron)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return;
        }
        CauldronEvent.Update event = new CauldronEvent.Update(tile);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        tile.adjustHeat();
        PrimalAPI.logger(23, "cauldron", "is hot: " + tile.isHot() + ", has fluid: " + tile.hasFluid() + ", has items: " + tile.hasInput());
        if (tile.isHot() && (tile.hasFluid() || tile.hasInput())) {
            PrimalAPI.logger(23, "cauldron", "is ready to match recipe");
            CauldronRecipe recipe = tile.matchRecipe();
            if (recipe != null) {
                if (tile.getCounter() == 0) {
                    tile.setRecipeTime(recipe);
                    this.playSoundMatch(world, pos, tile);
                }
                if (tile.getCounter() > 1) {
                    tile.reduceCounter();
                } else {
                    tile.finishRecipe(recipe);
                    CauldronRecipe recipe_continuation = tile.matchRecipe();
                    if (recipe_continuation != null) {
                        PrimalAPI.logger(23, "cauldron", "continue recipe processing");
                        tile.setRecipeTime(recipe_continuation);
                    } else {
                        PrimalAPI.logger(23, "cauldron", "no valid recipes remaining");
                        tile.resetCount();
                    }
                }
            } else {
                tile.resetCount();
            }
        } else {
            tile.resetCount();
        }
        this.scheduleUpdate(world, pos, state);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        super.func_180658_a(world, pos, entity, fallDistance);
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileCauldron) {
            this.playSoundHit(world, pos, ((TileCauldron)tile).getContainedFluid());
            if (entity instanceof EntityItem && !((TileCauldron)tile).isCovered()) {
                ((TileCauldron)tile).addIngredients((EntityItem)entity);
            }
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        RayTraceResult rayResult;
        if (world.field_72995_K) {
            return;
        }
        TileCauldron tile = (TileCauldron)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return;
        }
        this.playSoundHit(world, pos, tile.getContainedFluid());
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof CauldronLadle && (rayResult = ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)(((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() + 1.0))) != null) {
            stack.func_77973_b().func_180614_a(player, world, pos, EnumHand.MAIN_HAND, rayResult.field_178784_b, (float)(rayResult.field_72307_f.field_72450_a - (double)pos.func_177958_n()), (float)(rayResult.field_72307_f.field_72450_a - (double)pos.func_177956_o()), (float)(rayResult.field_72307_f.field_72450_a - (double)pos.func_177952_p()));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileCauldron tile = (TileCauldron)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return true;
        }
        FluidStack heldFluid = tile.getContainedFluid();
        ItemStack heldStack = player.func_184586_b(hand);
        if (tile.isCovered()) {
            this.playSoundHit(world, pos, heldFluid);
            return false;
        }
        IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face);
        if (handler == null) {
            return true;
        }
        if (player.func_70093_af() && face == EnumFacing.UP) {
            if (!tile.takeOutput(player) && !tile.takeInput(player)) {
                this.playSoundSwish(world, pos, heldFluid);
            }
            if (tile.isHot() && heldStack.func_190926_b()) {
                player.func_70097_a(DamageSource.field_76372_a, 0.5f);
            }
            return true;
        }
        if (this.isLid(world, pos, state, heldStack)) {
            CauldronEvent.Close close = new CauldronEvent.Close(tile, player);
            if (MinecraftForge.EVENT_BUS.post((Event)close)) {
                return false;
            }
            tile.setCovered(true);
            tile.updateBlock();
            PlayerHelper.useStack(player, hand, heldStack);
            this.playSoundLid(world, pos);
            return true;
        }
        if (this.isBottle(heldStack)) {
            BottleRecipe recipe;
            FluidStack fluidStack = handler.drain(250, false);
            if (fluidStack != null && 250 == fluidStack.amount && (recipe = BottleRecipe.getRecipe(fluidStack)) != null) {
                handler.drain(250, true);
                player.func_71029_a(StatList.field_188078_L);
                PlayerHelper.useStackTakeItem(player, hand, recipe.getOutput());
                Cauldron.playSoundFill(world, player.func_180425_c(), heldStack);
            }
            return true;
        }
        if (BottleRecipe.isOutput(heldStack)) {
            BottleRecipe recipe;
            FluidStack fluidStack = handler.drain(250, false);
            if (fluidStack != null && handler.fill(fluidStack, false) == fluidStack.amount) {
                BottleRecipe recipe2 = BottleRecipe.getRecipe(fluidStack);
                if (recipe2 != null && recipe2.getOutput().func_77969_a(heldStack)) {
                    handler.fill(fluidStack, true);
                    tile.reduceHeat(0.025f);
                    player.func_71029_a(StatList.field_188077_K);
                    PlayerHelper.useStackTakeItem(player, hand, new ItemStack(Items.field_151069_bo));
                    Cauldron.playSoundEmpty(world, player.func_180425_c(), heldStack);
                }
            } else if (fluidStack == null && (recipe = BottleRecipe.getRecipe(heldStack)) != null && handler.fill(fluidStack = new FluidStack(recipe.getInput(), 250), false) == fluidStack.amount) {
                handler.fill(new FluidStack(recipe.getInput(), 250), true);
                tile.reduceHeat(0.025f);
                player.func_71029_a(StatList.field_188077_K);
                PlayerHelper.useStackTakeItem(player, hand, new ItemStack(Items.field_151069_bo));
                Cauldron.playSoundEmpty(world, player.func_180425_c(), heldStack);
            }
            return true;
        }
        if (FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)handler)) {
            player.func_71029_a(StatList.field_188078_L);
            return true;
        }
        this.playSoundHit(world, pos, heldFluid);
        if (heldStack.func_77973_b() instanceof CauldronLadle) {
            heldStack.func_77973_b().func_180614_a(player, world, pos, hand, face, hitX, hitY, hitZ);
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        TileEntity tile;
        if (!entity.func_70045_F() && entity instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entity)) && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileCauldron && !((TileCauldron)tile).isCovered() && ((TileCauldron)tile).getHeat() > 0.9f) {
            entity.func_70097_a(DamageSource.field_190095_e, 0.5f);
        }
        super.func_176199_a(world, pos, entity);
    }

    @Override
    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        FluidStack fluidStack;
        super.onBlockExploded(world, pos, explosion);
        if (world.field_72995_K) {
            return;
        }
        TileCauldron tile = (TileCauldron)world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && (fluidStack = tile.getContainedFluid()) != null && fluidStack.getFluid() == FluidRegistry.getFluid((String)"paraffin")) {
            int amount = fluidStack.amount / 125;
            float factor = tile.isCovered() ? 1.5f : 1.0f;
            super.onBlockExploded(world, pos, explosion);
            FireHelper.explode(world, pos, null, RANDOM.nextInt(amount / 2, amount), factor, true, false);
            PrimalAPI.logger(25, "cauldron explosion", "fluid: " + fluidStack.getFluid() + ":" + fluidStack.amount + ":" + amount);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return this.doPickup(world, pos, state, EnumFacing.DOWN, player, player.func_184600_cs());
    }

    @Override
    public void dropItemsAndBlock(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileCauldron && !((TileCauldron)tile).isCovered()) {
            float offset = 0.7f;
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileCauldron)tile).getInputHandler());
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileCauldron)tile).getOutputHandler());
            PlayerHelper.spawnItemOnGround(world, pos, this.func_185473_a(world, pos, state));
        }
    }

    @Override
    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76230_c();
    }

    public void playSoundHit(World world, BlockPos pos, FluidStack fluid) {
        SoundCategory category = SoundCategory.BLOCKS;
        float variation = RANDOM.nextFloat() * 0.4f;
        float volume = 0.5f;
        if (fluid != null && fluid.amount > 0) {
            world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_CAULDRON_FILLED, category, volume, variation + 0.8f);
        } else {
            world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_CAULDRON_EMPTY, category, volume, variation + 0.8f);
        }
    }

    public void playSoundTake(World world, BlockPos pos, FluidStack fluid) {
        SoundCategory category = SoundCategory.BLOCKS;
        float variation = RANDOM.nextFloat() * 0.4f;
        float volume = 0.5f;
        if (fluid != null && fluid.amount > 0) {
            world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_CAULDRON_TAKE, category, volume, variation + 0.8f);
        } else {
            this.playSoundHit(world, pos, fluid);
        }
    }

    public void playSoundSwish(World world, BlockPos pos, FluidStack fluid) {
        if (fluid != null && fluid.amount > 0) {
            if (PrimalAPI.randomCheckFail(3)) {
                FXHelper.soundSwish(world, pos, 0.35f);
            }
        } else {
            this.playSoundHit(world, pos, fluid);
        }
    }

    public void playSoundLid(World world, BlockPos pos) {
        world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_CAULDRON_LID, SoundCategory.BLOCKS, 0.5f, RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public void playSoundMatch(World world, BlockPos pos, TileCauldron tile) {
        world.func_184133_a(null, pos, tile.hasFluid() ? PrimalAPI.Sounds.SOUND_BLOCK_CAULDRON_MATCH : PrimalAPI.Sounds.SOUND_MISC_STEAM, SoundCategory.BLOCKS, 0.5f, RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_POT;
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (this.isCovered((IBlockAccess)world, pos, state)) {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entityIn, isActualState);
        } else {
            Cauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.125, 0.2675, 0.125, 0.875, 0.3125, 0.875));
            Cauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.125, 0.2675, 0.125, 0.875, 0.815, 0.125));
            Cauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.125, 0.2675, 0.25, 0.875, 0.815, 0.875));
            Cauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.25, 0.2675, 0.125, 0.875, 0.815, 0.875));
            Cauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.125, 0.2675, 0.125, 0.125, 0.815, 1.0));
        }
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP && !this.isCovered(world, pos, state) ? BlockFaceShape.BOWL : BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        TileCauldron tile = (TileCauldron)world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && !tile.isCovered() && tile.isHot()) {
            FXHelper.makeParticles(world, pos, EnumParticleTypes.EXPLOSION_NORMAL, RANDOM.nextInt(2), 8, 0.9f, 0.0);
        }
    }
}

