/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.machines;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.types.ITypeMud;
import nmd.primal.core.api.interfaces.types.ITypeNBT;
import nmd.primal.core.common.blocks.AbstractBlockType;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.tile.HibachiRecipe;
import nmd.primal.core.common.tiles.machines.TileHibachi;

public class Hibachi
extends AbstractBlockType<TileHibachi>
implements ITypeMud,
IFace,
ISchedule,
ILit {
    public Hibachi() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)));
        this.setHarvestLevel("pickaxe", 0);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149713_g(0);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileHibachi();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.hibachi_crafting"));
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_requires_fuel"));
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isLit(world, pos, state) ? PathNodeType.DAMAGE_FIRE : super.getAiPathNodeType(state, world, pos);
    }

    @Override
    public boolean canInteract(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN;
    }

    @Override
    public boolean canLite(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && !tile.func_145837_r() && tile instanceof TileHibachi && ((TileHibachi)tile).hasFuelItems();
    }

    @Override
    public boolean canExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityLivingBase entity) {
        return entity == null || TileEntityFurnace.func_145952_a((ItemStack)entity.func_184586_b(EnumHand.MAIN_HAND)) < 1;
    }

    @Override
    public boolean doLite(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileHibachi && ((TileHibachi)tile).hasFuelItems()) {
            ((TileHibachi)tile).consumeFuel();
            if (world.func_180501_a(pos, state.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true)), 2)) {
                FireHelper.makeSmoke(world, pos, 16);
                world.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileHibachi) {
            ((TileHibachi)tile).setFuelTime(0);
            if (world.func_180501_a(pos, state.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)), 2)) {
                FireHelper.makeSmoke(world, pos, 16);
                world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && !tile.func_145837_r() && tile instanceof TileHibachi && this.isLit((IBlockAccess)world, pos, state);
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return false;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return ModConfig.Machines.HIBACHI_TICK_RATE;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        TileHibachi tile = (TileHibachi)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return;
        }
        PrimalAPI.logger(22, "scheduled update", "hibachi");
        if (this.isLit((IBlockAccess)world, pos, state)) {
            tile.consumeFuel();
            if (tile.hasFuelItems()) {
                tile.cookItems(world, pos);
            } else {
                this.doExtinguish(world, pos, state, EnumFacing.UP, null);
            }
        }
        this.scheduleUpdate(world, pos, state);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        TileHibachi tile = (TileHibachi)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return;
        }
        RayTraceResult rayResult = ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)(((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() + 1.0));
        if (rayResult == null) {
            return;
        }
        PrimalAPI.logger(22, "hibachi", "clicked");
        EnumFacing face = rayResult.field_178784_b;
        if (face != EnumFacing.UP && face != EnumFacing.DOWN) {
            ItemStackHandler stackHandler = tile.getFuelHandler();
            int slot = 0;
            ItemStack held_stack = player.func_184586_b(EnumHand.MAIN_HAND);
            if (tile.isValidFuel(held_stack)) {
                ItemStack add_stack = held_stack.func_77946_l();
                add_stack.func_190918_g(held_stack.func_190916_E() - 1);
                ItemStack remainder = stackHandler.insertItem(slot, add_stack, false);
                if (remainder.func_190926_b()) {
                    held_stack.func_190918_g(1);
                }
                SoundType soundtype = SoundType.field_185849_b;
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileHibachi tile = (TileHibachi)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return false;
        }
        ItemStack held_stack = player.func_184614_ca();
        PrimalAPI.logger(22, "hibachi", "activated: " + held_stack);
        if (face == EnumFacing.UP) {
            int slot = this.getSlot(state, hitX, hitY, hitZ);
            if (slot > -1) {
                ItemStackHandler craftingHandler = tile.getCraftingHandler();
                ItemStack shelf_stack = craftingHandler.getStackInSlot(slot);
                if (!shelf_stack.func_190926_b()) {
                    int stack_size;
                    int n = stack_size = player.func_70093_af() ? shelf_stack.func_190916_E() : 1;
                    if (stack_size > 0) {
                        ItemStack take_stack = craftingHandler.extractItem(slot, stack_size, false);
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)take_stack.func_77946_l());
                    }
                    tile.resetSlotCount(slot);
                } else {
                    HibachiRecipe recipe = tile.matchRecipe(held_stack);
                    if (recipe != null && CommonUtils.addStack(craftingHandler, player, held_stack, slot)) {
                        SoundType soundtype = SoundType.field_185852_e;
                        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundtype.func_185842_g(), SoundCategory.BLOCKS, 0.5f, soundtype.func_185847_b() * 0.8f);
                    }
                }
                return true;
            }
        } else if (face != EnumFacing.DOWN) {
            int slot = 0;
            if (this.isFuelSlot(hitX, hitY, hitZ)) {
                ItemStackHandler fuelHandler = tile.getFuelHandler();
                ItemStack fuel_stack = fuelHandler.getStackInSlot(slot);
                if (!fuel_stack.func_190926_b()) {
                    if (!held_stack.func_190926_b() && held_stack.func_77969_a(fuel_stack)) {
                        if (fuel_stack.func_190916_E() <= fuelHandler.getSlotLimit(slot) && CommonUtils.addStack(fuelHandler, player, held_stack, slot)) {
                            SoundType soundtype = SoundType.field_185849_b;
                            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                        }
                    } else if (!this.isLit((IBlockAccess)world, pos, state)) {
                        ItemStack take_stack = fuelHandler.extractItem(slot, player.func_70093_af() ? fuel_stack.func_190916_E() : 1, false);
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)take_stack.func_77946_l());
                    }
                } else if (CommonUtils.addStack(fuelHandler, player, held_stack, slot)) {
                    SoundType soundtype = SoundType.field_185849_b;
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                }
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        IBlockState state;
        if (!entity.func_70045_F() && entity instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entity)) && this.isLit((IBlockAccess)world, pos, state = world.func_180495_p(pos))) {
            entity.func_70097_a(DamageSource.field_190095_e, 1.0f);
        }
        super.func_176199_a(world, pos, entity);
    }

    private boolean isFuelSlot(float hitX, float hitY, float hitZ) {
        return hitY < 0.62f && hitY > 0.42f;
    }

    private int getSlot(IBlockState state, float hitX, float hitY, float hitZ) {
        return this.getHorizontalRackIndex(state, hitX, hitZ) + this.getVerticalRackIndex(state, hitX, hitZ);
    }

    private int getHorizontalRackIndex(IBlockState state, float hitX, float hitZ) {
        switch ((EnumFacing)state.func_177229_b((IProperty)IFace.FACING)) {
            case NORTH: {
                return hitZ < 0.5f ? 0 : 2;
            }
            case EAST: {
                return hitX > 0.5f ? 0 : 2;
            }
            case SOUTH: {
                return hitZ > 0.5f ? 0 : 2;
            }
            case WEST: {
                return hitX < 0.5f ? 0 : 2;
            }
        }
        return -10;
    }

    private int getVerticalRackIndex(IBlockState state, float hitX, float hitZ) {
        switch ((EnumFacing)state.func_177229_b((IProperty)IFace.FACING)) {
            case NORTH: {
                return hitX < 0.5f ? 0 : 1;
            }
            case EAST: {
                return hitZ < 0.5f ? 0 : 1;
            }
            case SOUTH: {
                return hitX > 0.5f ? 0 : 1;
            }
            case WEST: {
                return hitZ > 0.5f ? 0 : 1;
            }
        }
        return -10;
    }

    @Override
    public void dropItemsAndBlock(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileHibachi) {
            float offset = 0.7f;
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileHibachi)tile).getCraftingHandler());
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileHibachi)tile).getFuelHandler());
            PlayerHelper.spawnItemOnGround(world, pos, this.func_185473_a(world, pos, state));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_HIBACHI;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileHibachi && this.isLit(world, pos, state)) {
            return 10;
        }
        return state.func_185906_d();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        EnumFacing face = target.field_178784_b;
        if (face != EnumFacing.UP && face != EnumFacing.DOWN) {
            return true;
        }
        return super.addHitEffects(state, world, target, manager);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isLit((IBlockAccess)world, pos, state)) {
            int i;
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.2 + RANDOM.nextDouble(0.1, 0.4);
            double z = (double)pos.func_177952_p() + 0.5;
            if (PrimalAPI.randomCheck(0.1f)) {
                SoundEvent sound = world.func_175727_C(pos) ? SoundEvents.field_187646_bt : SoundEvents.field_187652_bv;
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, sound, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            for (i = 0; i < 2 + rand.nextInt(3); ++i) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + (RANDOM.nextDouble() * 0.6 - 0.3), y, z + (RANDOM.nextDouble() * 0.6 - 0.3), 0.0, 0.0, 0.0, new int[0]);
            }
            for (i = 0; i < 2 + rand.nextInt(3); ++i) {
                world.func_175688_a(EnumParticleTypes.FLAME, x + (RANDOM.nextDouble() * 0.6 - 0.3), y, z + (RANDOM.nextDouble() * 0.6 - 0.3), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)IFace.FACING, (Comparable)placer.func_174811_aO());
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileHibachi tile = (TileHibachi)world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r()) {
            tile.setRotation((byte)placer.func_174811_aO().func_176736_b());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (ITypeMud.EnumType blocks$enumtype : ITypeMud.EnumType.values()) {
            ItemStack stack = new ItemStack((Block)this, 1, blocks$enumtype.getMetadata());
            NBTHelper.setString(stack, "type", blocks$enumtype.func_176610_l());
            list.add((Object)stack);
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            ItemStack stack = new ItemStack((Block)this, 1, ITypeMud.EnumType.byName(((ITypeNBT)tile).getType()).getMetadata());
            NBTHelper.setString(stack, "type", ((ITypeNBT)tile).getType());
            return stack;
        }
        return super.func_185473_a(world, pos, state);
    }

    @Override
    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.getTypeHardness((IBlockAccess)world, pos, world.func_180495_p(pos));
    }

    @Override
    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.getTypeResistance((IBlockAccess)world, pos, world.func_180495_p(pos));
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IFace.FACING, ITypeMud.TYPE, ILit.LIT});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)IFace.FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IFace.FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            return state.func_177226_a(ITypeMud.TYPE, (Comparable)((Object)ITypeMud.EnumType.byName(((ITypeNBT)tile).getType())));
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)IFace.FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)IFace.FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)IFace.FACING)));
    }
}

